﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.PatientSchemas
{
    /// <summary>
    /// This object is used for the packaged response from the Patient List web service interface.
    /// </summary>
    [Serializable]
    [DataContract(Name = "PatientListResponse")]
    public class PatientListResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private IList<PatientInHospital> patientList = new List<PatientInHospital>();

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentList IList.
        /// List of the Document Meta Data Items.
        /// </summary>
        /// <value>
        /// The DocumentList
        /// </value>
        [DataMember]
        public IList<PatientInHospital> PatientInHospitalList
        {
            get { return patientList; }
            set { patientList = value; }
        }

        #endregion Properties
    }
}