﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class provides access  to the country table
    /// </summary>
    public class AddressTypeDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<AddressType> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all details that have changed since the last update.
        /// </summary>
        /// <param name="lastUpdated">The last updated.</param>
        /// <returns></returns>
        public List<AddressType> GetAll(DateTime? lastUpdated)
        {
            List<AddressType> results = new List<AddressType>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.AddressTypeGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<AddressType>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageAddressTypeGet, ex, User, LogMessage.HIPS_MESSAGE_039);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified AddressType id.
        /// </summary>
        /// <param name="AddressTypeId">The AddressType id.</param>
        /// <returns></returns>
        public AddressType Get(int addressTypeId)
        {
            AddressType result = new AddressType();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.AddressTypeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@AddressTypeId", addressTypeId));
                    PopulateBusinessObject<AddressType>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageAddressTypeGet, ex, User, LogMessage.HIPS_MESSAGE_040);
            }
            return result;
        }

        #endregion Methods
    }
}