﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Schemas;
using System.Linq;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class retrieves data to allow PCEHR registration for existing patients
    /// </summary>
    public class AssistedRegistrationDl : BaseDl
    {
        #region Private Members

        #endregion Private Members

        #region Properties

        #endregion Properties

        #region Methods


        /// <summary>
        /// Lists the patients without pcehr.
        /// </summary>
        /// <param name="hospitalId">The hospital identifier.</param>
        /// <returns>List of patients without a PCEHR</returns>
        public List<PatientWithoutPcehr> ListPatientsWithoutPcehr(string hospitalCodeSystem, int? hospitalId)
        {
            List<PatientWithoutPcehr> results = new List<PatientWithoutPcehr>();
            try
            {
                // Populate the patient list
                using (SqlCommand command = GetSqlCommand("hips.PatientsWithoutPcehrList"))
                {
                    command.Parameters.Add(new SqlParameter("@HospitalCodeSystem", hospitalCodeSystem));
                    if (hospitalId.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@HospitalId", hospitalId));
                    }
                    results = GetPopulatedBusinessList<PatientWithoutPcehr>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                // TODO : Need to update the error messages
                EventLogger.WriteLog(ConstantsResource.ErrorMessageHospitalGet, ex, User, LogMessage.HIPS_MESSAGE_063);
            }
            return results;
        }

        #endregion Methods
    }
}