﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Namespace table
    /// </summary>
    public class CodeSystemDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<CodeSystem> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<CodeSystem> GetAll(DateTime? lastUpdated)
        {
            List<CodeSystem> results = new List<CodeSystem>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.CodeSystemGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated.Value));
                    }
                    results = GetPopulatedBusinessList<CodeSystem>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageCodeSystemGet, ex, User, LogMessage.HIPS_MESSAGE_034);
            }
            return results;
        }

        /// <summary>
        /// Gets the code system with the specified code system id.
        /// </summary>
        /// <param name="codeSystemId">The code system id.</param>
        /// <returns></returns>
        public CodeSystem Get(int codeSystemId)
        {
            CodeSystem result = new CodeSystem();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.CodeSystemGet"))
                {
                    command.Parameters.Add(new SqlParameter("@CodeSystemId", codeSystemId));
                    PopulateBusinessObject<CodeSystem>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageCodeSystemGet, ex, User, LogMessage.HIPS_MESSAGE_035);
            }
            return result;
        }

        #endregion Methods
    }
}