﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class provides access  to the country table
    /// </summary>
    public class CountryDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Country> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all details that have changed since the last update.
        /// </summary>
        /// <param name="lastUpdated">The last updated.</param>
        /// <returns></returns>
        public List<Country> GetAll(DateTime? lastUpdated)
        {
            List<Country> results = new List<Country>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.CountryGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<Country>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageCountryGet, ex, User, LogMessage.HIPS_MESSAGE_041);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified Country id.
        /// </summary>
        /// <param name="CountryId">The Country id.</param>
        /// <returns></returns>
        public Country Get(int countryId)
        {
            Country result = new Country();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.CountryGet"))
                {
                    command.Parameters.Add(new SqlParameter("@CountryId", countryId));
                    PopulateBusinessObject<Country>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageCountryGet, ex, User, LogMessage.HIPS_MESSAGE_042);
            }
            return result;
        }

        #endregion Methods
    }
}