﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using Enums = HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the DocumentType table
    /// </summary>
    public class DocumentTypeDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<DocumentType> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<DocumentType> GetAll(DateTime? lastUpdated)
        {
            List<DocumentType> results = new List<DocumentType>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.DocumentTypeGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated.Value));
                    }
                    results = GetPopulatedBusinessList<DocumentType>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDocumentTypeGet, ex, User, Enums.LogMessage.HIPS_MESSAGE_026);
            }
            return results;
        }

        /// <summary>
        /// Gets the document type with the specified document type id.
        /// </summary>
        /// <param name="documentTypeId">The document type id.</param>
        /// <returns>The document type object</returns>
        public DocumentType Get(int documentTypeId)
        {
            DocumentType result = new DocumentType();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.DocumentTypeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@DocumentTypeId", documentTypeId));
                    PopulateBusinessObject<DocumentType>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDocumentTypeGet, ex, User, Enums.LogMessage.HIPS_MESSAGE_027);
            }
            return result;
        }

        #endregion Methods
    }
}