﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the DownloadedDocument table
    /// </summary>
    public class DownloadedDocumentDl : BaseDl
    {
        #region Constructors

        public DownloadedDocumentDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<DownloadedDocument> GetAll(int patientMasterId)
        {
            List<DownloadedDocument> results = new List<DownloadedDocument>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.DownloadedDocumentGet"))
                {
                    AddIntParameter("PatientMasterId", patientMasterId, command);
                    results = GetPopulatedBusinessList<DownloadedDocument>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string description = string.Format(ConstantsResource.ErrorMessageDownloadedDocumentGetAll, patientMasterId);
                EventLogger.WriteLog(description, ex, User, LogMessage.HIPS_MESSAGE_011);
            }
            return results;
        }

        /// <summary>
        /// Gets the document version with a given source system document ID.
        /// </summary>
        /// <param name="sourceSystemDocumentId">The source system document id.</param>
        /// <param name="item">Outputs the clinical document version</param>
        /// <returns>Whether the version was retrieved</returns>
        public bool Get(string sourceSystemDocumentId, out DownloadedDocument item)
        {
            bool result = false;
            item = new DownloadedDocument();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.DownloadedDocumentGet"))
                {
                    AddStringParameter("SourceSystemDocumentId", sourceSystemDocumentId, command);
                    PopulateBusinessObject<DownloadedDocument>(command.ExecuteReader(), item);
                    command.Connection.Close();
                    result = true;
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(string.Format(ConstantsResource.ErrorMessageDownloadedDocumentGet, sourceSystemDocumentId), ex, User, LogMessage.HIPS_MESSAGE_012);
            }
            return result;
        }

        /// <summary>
        /// Saves the specified DownloadedDocument.
        /// </summary>
        /// <param name="item">The DownloadedDocument.</param>
        /// <returns>Whether the item was saved</returns>
        public bool Save(DownloadedDocument item, SqlTransaction transaction = null)
        {
            if (item.DownloadedDocumentId.HasValue)
            {
                return Update(item, transaction);
            }
            else
            {
                return Insert(item, transaction);
            }
        }

        /// <summary>
        /// Inserts the specified DownloadedDocument.
        /// </summary>
        /// <param name="item">The DownloadedDocument.</param>
        /// <returns></returns>
        private bool Insert(DownloadedDocument item, SqlTransaction transaction)
        {
            using (SqlCommand command = GetSqlCommand("hips.DownloadedDocumentInsert", transaction))
            {
                return base.Insert<DownloadedDocument>(item, command);
            }
        }

        /// <summary>
        /// Updates the specified DownloadedDocument.
        /// </summary>
        /// <param name="item">The DownloadedDocument.</param>
        /// <returns></returns>
        private bool Update(DownloadedDocument item, SqlTransaction transaction)
        {
            using (SqlCommand command = GetSqlCommand("hips.DownloadedDocumentUpdate", transaction))
            {
                return base.Update<DownloadedDocument>(item, command);
            }
        }

        #endregion Methods
    }
}