﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the EpisodeType table
    /// </summary>
    public class EpisodeTypeDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<EpisodeType> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<EpisodeType> GetAll(DateTime? lastUpdated)
        {
            List<EpisodeType> results = new List<EpisodeType>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.EpisodeTypeGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated.Value));
                    }
                    results = GetPopulatedBusinessList<EpisodeType>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageEpisodeTypeGet, ex, User, LogMessage.HIPS_MESSAGE_032);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified EpisodeType id.
        /// </summary>
        /// <param name="EpisodeTypeId">The EpisodeType id.</param>
        /// <returns></returns>
        public EpisodeType Get(int EpisodeTypeId)
        {
            EpisodeType result = new EpisodeType();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.EpisodeTypeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@EpisodeTypeId", EpisodeTypeId));
                    PopulateBusinessObject<EpisodeType>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageEpisodeTypeGet, ex, User, LogMessage.HIPS_MESSAGE_033);
            }
            return result;
        }

        #endregion Methods
    }
}