﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HealthProviderOrganisation table
    /// </summary>
    public class HealthProviderOrganisationDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<HealthProviderOrganisation> GetAll()
        {
            List<HealthProviderOrganisation> results = new List<HealthProviderOrganisation>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HealthProviderOrganisationGet"))
                {
                    results = GetPopulatedBusinessList<HealthProviderOrganisation>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageHealthProviderOrganisationGetAll, ex, User, LogMessage.HIPS_MESSAGE_138);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified HealthProviderOrganisation id.
        /// </summary>
        /// <param name="HealthProviderOrganisationId">The HealthProviderOrganisation id.</param>
        /// <returns></returns>
        public HealthProviderOrganisation Get(int healthProviderOrganisationId)
        {
            HealthProviderOrganisation result = new HealthProviderOrganisation();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HealthProviderOrganisationGet"))
                {
                    command.Parameters.Add(new SqlParameter("@HealthProviderOrganisationId", healthProviderOrganisationId));
                    PopulateBusinessObject<HealthProviderOrganisation>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessageHealthProviderOrganisationGet, healthProviderOrganisationId);
                EventLogger.WriteLog(message, ex, User, LogMessage.HIPS_MESSAGE_139);
            }
            return result;
        }

        #endregion Methods
    }
}