﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HospitalHealthProviderIndividual table
    /// </summary>
    public class HospitalHealthProviderIndividualDl : BaseDl
    {
        #region Constructors

        /// <summary>
        /// Creates a data access object for the link between a hospital and a health provider individual.
        /// </summary>
        /// <param name="user">The person responsible for the action.</param>
        public HospitalHealthProviderIndividualDl(UserDetails user)
        {
            this.User = user;
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        //TODO: Not implemented yet as it is not required right now.
        public List<HospitalHealthProviderIndividual> GetAll(int healthProviderIndividualId)
        {
            throw new NotImplementedException("This method has not been implemented");

            //List<HospitalHealthProviderIndividual> results = new List<HospitalHealthProviderIndividual>();
            //try
            //{
            //    using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualGet"))
            //    {
            //        results = GetPopulatedBusinessList<HospitalHealthProviderIndividual>(command.ExecuteReader());
            //        command.Connection.Close();
            //    }
            //}
            //catch (Exception ex)
            //{
            //    EventLogger.WriteLog(ConstantsResource.ErrorMessageHospitalHealthProviderIndividualGet, ex, User);
            //}
            //return results;
        }

        /// <summary>
        /// Inserts the specified hospital health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        public bool Insert(HospitalHealthProviderIndividual hospitalHealthProviderIndividual, SqlTransaction transaction)
        {
            using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualInsert", transaction))
            {
                return base.Insert<HospitalHealthProviderIndividual>(hospitalHealthProviderIndividual, command);
            }
        }

        /// <summary>
        /// Updates the specified health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        //TODO: Not implemented yet as it is not required right now.
        public bool Update(HospitalHealthProviderIndividual hospitalHealthProviderIndividual)
        {
            throw new NotImplementedException("This method has not been implemented");

            //using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualUpdate"))
            //{
            //    return base.Update<HospitalHealthProviderIndividual>(hospitalHealthProviderIndividual, command);
            //}
        }

        /// <summary>
        /// Deletes the specified health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        //TODO: Not implemented yet as it is not required right now.
        public bool Delete(HospitalHealthProviderIndividual hospitalHealthProviderIndividual)
        {
            throw new NotImplementedException("This method has not been implemented");

            //using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualDelete"))
            //{
            //    return base.Delete<HospitalHealthProviderIndividual>(hospitalHealthProviderIndividual, command);
            //}
        }

        #endregion Methods
    }
}