﻿using System;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Patient Master Address table
    /// </summary>
    public class PatientMasterAddressDl : BaseDl
    {
        /// <summary>
        /// Gets the specified PatientMasterAddress id.
        /// </summary>
        /// <param name="PatientMasterAddressId">The PatientMasterAddress id.</param>
        /// <returns></returns>
        public PatientMasterAddress Get(int PatientMasterId, int AddressId)
        {
            PatientMasterAddress result = new PatientMasterAddress();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.PatientMasterAddressGet"))
                {
                    AddIntParameter("@PatientMasterId", PatientMasterId, command);
                    AddIntParameter("@AddressId", AddressId, command);
                    PopulateBusinessObject<PatientMasterAddress>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageAddressGet, ex, User, LogMessage.HIPS_MESSAGE_003);
            }
            return result;
        }

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Insert(PatientMasterAddress item)
        {
            using (SqlCommand command = GetSqlCommand("hips.PatientMasterAddressInsert"))
            {
                return base.Insert<PatientMasterAddress>(item, command);
            }
        }

        /// <summary>
        /// Deletes the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Delete(PatientMasterAddress item)
        {
            using (SqlCommand command = GetSqlCommand("hips.PatientMasterAddressDelete"))
            {
                return base.Delete<PatientMasterAddress>(item, command);
            }
        }
    }
}