﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrDataStore.Schemas.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the RemovalStatus table
    /// </summary>
    public class RemovalStatusDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<RemovalStatus> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        ///
        /// </summary>
        /// <param name="removalStatusId"></param>
        /// <returns></returns>
        private List<RemovalStatus> GetAll(int? removalStatusId)
        {
            List<RemovalStatus> results = new List<RemovalStatus>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.RemovalStatusGet"))
                {
                    if (removalStatusId.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@RemovalStatusId", removalStatusId));
                    }
                    results = GetPopulatedBusinessList<RemovalStatus>(command.ExecuteReader());
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorRemovalStatusGet, ex, User, LogMessage.HIPS_MESSAGE_038);
            }
            finally
            {
                Command.Connection.Close();
            }
            return results;
        }

        /// <summary>
        /// Gets the specified RemovalStatus id.
        /// </summary>
        /// <param name="RemovalStatusId">The RemovalStatus id.</param>
        /// <returns></returns>
        public RemovalStatus Get(int removalStatusId)
        {
            return GetAll(removalStatusId).First();
        }

        #endregion Methods
    }
}