﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Base.Schemas;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the SexCode table
    /// </summary>
    public class SexCodeDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="codeSystemCode">The code system code.</param>
        /// <returns></returns>
        public List<T> GetAll<T>(string codeSystemCode) where T : BaseExposedCode, new()
        {
            List<T> results = new List<T>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.SexCodeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@CodeSystemCode", codeSystemCode));
                    results = GetPopulatedBusinessList<T>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSexCodeGet, ex, User, LogMessage.HIPS_MESSAGE_154);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified SexCode id.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="codeSystemId">The code system identifier.</param>
        /// <param name="sexId">The Postal Delivery type identifier.</param>
        /// <returns></returns>
        public T Get<T>(int codeSystemId, int sexId) where T : BaseExposedCode, new()
        {
            T result = new T();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.SexCodeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@CodeSystemId", codeSystemId));
                    command.Parameters.Add(new SqlParameter("@SexId", sexId));
                    PopulateBusinessObject<T>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSexCodeGet, ex, User, LogMessage.HIPS_MESSAGE_155);
            }
            return result;
        }

        #endregion Methods
    }
}