﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Base.Schemas;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the StateCode table
    /// </summary>
    public class StateCodeDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="codeSystemCode">The code system code.</param>
        /// <returns></returns>
        public List<T> GetAll<T>(string codeSystemCode) where T : BaseExposedCode, new()
        {
            List<T> results = new List<T>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.StateCodeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@CodeSystemCode", codeSystemCode));
                    results = GetPopulatedBusinessList<T>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageStateCodeGet, ex, User, LogMessage.HIPS_MESSAGE_150);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified StateCode id.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="codeSystemId">The code system identifier.</param>
        /// <param name="stateId">The Postal Delivery type identifier.</param>
        /// <returns></returns>
        public T Get<T>(int codeSystemId, int stateId) where T : BaseExposedCode, new()
        {
            T result = new T();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.StateCodeGet"))
                {
                    command.Parameters.Add(new SqlParameter("@CodeSystemId", codeSystemId));
                    command.Parameters.Add(new SqlParameter("@StateId", stateId));
                    PopulateBusinessObject<T>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageStateCodeGet, ex, User, LogMessage.HIPS_MESSAGE_151);
            }
            return result;
        }

        #endregion Methods
    }
}