﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the State table
    /// </summary>
    public class StateDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<State> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<State> GetAll(DateTime? lastUpdated)
        {
            List<State> results = new List<State>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.StateGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<State>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageStateGet, ex, User, LogMessage.HIPS_MESSAGE_020);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified State id.
        /// </summary>
        /// <param name="StateId">The State id.</param>
        /// <returns></returns>
        public State Get(int StateId)
        {
            State result = new State();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.StateGet"))
                {
                    command.Parameters.Add(new SqlParameter("@StateId", StateId));
                    PopulateBusinessObject<State>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageStateGet, ex, User, LogMessage.HIPS_MESSAGE_021);
            }
            return result;
        }

        #endregion Methods
    }
}