﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Suffix table
    /// </summary>
    public class SuffixDl : BaseDl
    {
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Suffix> GetAll()
        {
            return GetAll(null);
        }

        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Suffix> GetAll(DateTime? lastUpdated)
        {
            List<Suffix> results = new List<Suffix>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.SuffixGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<Suffix>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSuffixGet, ex, User, LogMessage.HIPS_MESSAGE_024);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified Suffix id.
        /// </summary>
        /// <param name="SuffixId">The Suffix id.</param>
        /// <returns></returns>
        public Suffix Get(int SuffixId)
        {
            Suffix result = new Suffix();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.SuffixGet"))
                {
                    command.Parameters.Add(new SqlParameter("@SuffixId", SuffixId));
                    PopulateBusinessObject<Suffix>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSuffixGet, ex, User, LogMessage.HIPS_MESSAGE_025);
            }
            return result;
        }

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <param name="connection">The connection.</param>
        /// <param name="transaction">The transaction.</param>
        /// <returns></returns>
        public bool Insert(Suffix item, SqlTransaction transaction = null)
        {
            using (SqlCommand command = GetSqlCommand("hips.SuffixInsert", transaction))
            {
                return base.Insert<Suffix>(item, command);
            }
        }

        #endregion Methods
    }
}