﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Title table
    /// </summary>
    public class TitleDl : BaseDl
    {
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Title> GetAll()
        {
            return GetAll(null);
        }

        #region Methods

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Title> GetAll(DateTime? lastUpdated)
        {
            List<Title> results = new List<Title>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.TitleGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<Title>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageTitleGet, ex, User, LogMessage.HIPS_MESSAGE_022);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified Title id.
        /// </summary>
        /// <param name="TitleId">The Title id.</param>
        /// <returns></returns>
        public Title Get(int TitleId)
        {
            Title result = new Title();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.TitleGet"))
                {
                    command.Parameters.Add(new SqlParameter("@TitleId", TitleId));
                    PopulateBusinessObject<Title>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageTitleGet, ex, User, LogMessage.HIPS_MESSAGE_023);
            }
            return result;
        }

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <param name="connection">The connection.</param>
        /// <param name="transaction">The transaction.</param>
        /// <returns></returns>
        public bool Insert(Title item, SqlTransaction transaction = null)
        {
            using (SqlCommand command = GetSqlCommand("hips.TitleInsert", transaction))
            {
                return base.Insert<Title>(item, command);
            }
        }

        #endregion Methods
    }
}