﻿using System;

namespace HIPS.PcehrDataStore.Schemas.Enumerators
{
    [Serializable]
    public enum Option
    {
        Information,
        Episodes,
        Pathology,
        Radiology,
        Discharge,
        Pcehr
    }

    [Serializable]
    public enum SexEnumerator
    {
        NotStatedOrInadequatelyDescribed = -1,
        Male = 1,
        Female = 2,
        IntersexOrIndeterminate = 3,
    }

    /// <summary>
    ///This is used to match the death indicator table to code
    /// </summary>
    [Serializable]
    public enum DeathIndicator
    {
        Unknown = -1,  // this would only ever happen if something was seriously wrong - as incorrect dates will get set as InvalidDate
        ValidDate = 1,
        InvalidDate = 2
    }

    /// <summary>
    ///This is used to match the record status in the IhiRecordStatus table to code
    /// </summary>
    [Serializable]
    public enum IhiRecordStatus
    {
        Verified = 1,
        Unverified = 2,
        Provisional = 3,
        Unknown = -1
    }

    /// <summary>
    /// This is used to match the status in the IhiStatus table to code
    /// </summary>
    [Serializable]
    public enum IhiStatus
    {
        Active = 1,
        Deceased = 2,
        Retired = 3,
        Expired = 4,
        Resolved = 5,
        Unknown = -1,
        DuplicateIhi = 100,
        DuplicatePatient = 101,
        MergeConflict = 102,
        ServiceUnavailable = 103,
        MedicareDvaChangeMismatch = 104,
        DemographicMismatch = 105
    }

    /// <summary>
    /// This is used to match the clinical document status id to code
    /// against sql table
    /// </summary>
    [Serializable]
    public enum ClinicalDocumentStatus
    {
        Active = 1,
        Removed = 2
    }

    /// <summary>
    /// This is used to match the status in the AccessCodeRequired table to code
    /// </summary>
    [Serializable]
    public enum AccessCodeRequired
    {
        /// <summary>
        /// The access status is unknown.
        /// </summary>
        Unknown = -1,

        /// <summary>
        /// Except in an emergency, the patient must provide his/her
        /// Record Access Code for the healthcare provider organisation
        /// to gain access to this PCEHR.
        /// </summary>
        WithCode = 0,

        /// <summary>
        /// No code is required for the health provider organisation
        /// to gain access to this PCEHR.
        /// </summary>
        WithoutCode = 1,

        /// <summary>
        /// The health provider organisation has already gained
        /// access to this PCEHR.
        /// </summary>
        AccessGranted = 2,
    }

    /// <summary>
    /// This enum is used to match the removal reason id in the RemovalReason table to code.
    /// The values of the IDs should also be kept in sync with the NEHTA enum <see cref="Nehta.VendorLibrary.PCEHR.RemoveDocument.removeDocumentReasonForRemoval"/>.
    /// Note: The NEHTA enum has an extra item "ElectToRemove", which is omitted from this enum because that is defined for consumer use only.
    /// </summary>
    [Serializable]
    public enum RemovalReason
    {
        Withdrawn = 0,
        IncorrectIdentity = 2
    }

    /// <summary>
    /// This enum is used to match the RepositoryId in the DocumentType table to code.
    /// </summary>
    [Serializable]
    public enum Repository
    {
        PCEHR = 1,
        NPDR = 2
    }

    /// <summary>
    /// This is used to match the episode lifecycle in the EpisodeLifecycle table to code.
    /// </summary>
    [Serializable]
    public enum EpisodeLifecycle
    {
        UnknownAppointmentStatus = -1,
        Booked = 1,
        AttendedSeen = 2,
        Deleted = 3,
        CancelledByPatient = 4,
        CancelledByHospital = 5,
        CancelledOther = 6,
        FailedToAttend = 7,
        PreAdmit = 9,
        CancelledPreAdmit = 10,
        Admitted = 11,
        CancelledAdmission = 12,
        Discharged = 13,
        Merged = 14
    }

    /// <summary>
    /// This is used to match the QueueOperation table to code.
    /// </summary>
    [Serializable]
    public enum QueueOperation
    {
        UploadOrSupersede = 1,
        Remove = 2
    }

    /// <summary>
    /// This is used to match the QueueStatus table to code.
    /// </summary>
    [Serializable]
    public enum QueueStatus
    {
        Pending = 1,
        Success = 2,
        Failure = 3
    }

    /// <summary>
    /// This is used to match the LogMessage table to code.
    /// </summary>
    [Serializable]
    public enum LogMessage
    {
        HIPS_MESSAGE_001 = 1,
        HIPS_MESSAGE_002 = 2,
        HIPS_MESSAGE_003 = 3,
        HIPS_MESSAGE_004 = 4,
        HIPS_MESSAGE_005 = 5,
        HIPS_MESSAGE_006 = 6,
        HIPS_MESSAGE_007 = 7,
        HIPS_MESSAGE_008 = 8,
        HIPS_MESSAGE_009 = 9,
        HIPS_MESSAGE_010 = 10,
        HIPS_MESSAGE_011 = 11,
        HIPS_MESSAGE_012 = 12,
        HIPS_MESSAGE_013 = 13,
        HIPS_MESSAGE_014 = 14,
        HIPS_MESSAGE_015 = 15,
        HIPS_MESSAGE_016 = 16,
        HIPS_MESSAGE_017 = 17,
        HIPS_MESSAGE_018 = 18,
        HIPS_MESSAGE_019 = 19,
        HIPS_MESSAGE_020 = 20,
        HIPS_MESSAGE_021 = 21,
        HIPS_MESSAGE_022 = 22,
        HIPS_MESSAGE_023 = 23,
        HIPS_MESSAGE_024 = 24,
        HIPS_MESSAGE_025 = 25,
        HIPS_MESSAGE_026 = 26,
        HIPS_MESSAGE_027 = 27,
        HIPS_MESSAGE_028 = 28,
        HIPS_MESSAGE_029 = 29,
        HIPS_MESSAGE_030 = 30,
        HIPS_MESSAGE_031 = 31,
        HIPS_MESSAGE_032 = 32,
        HIPS_MESSAGE_033 = 33,
        HIPS_MESSAGE_034 = 34,
        HIPS_MESSAGE_035 = 35,
        HIPS_MESSAGE_036 = 36,
        HIPS_MESSAGE_037 = 37,
        HIPS_MESSAGE_038 = 38,
        HIPS_MESSAGE_039 = 39,
        HIPS_MESSAGE_040 = 40,
        HIPS_MESSAGE_041 = 41,
        HIPS_MESSAGE_042 = 42,
        HIPS_MESSAGE_043 = 43,
        HIPS_MESSAGE_044 = 44,
        HIPS_MESSAGE_045 = 45,
        HIPS_MESSAGE_046 = 46,
        HIPS_MESSAGE_047 = 47,
        HIPS_MESSAGE_048 = 48,
        HIPS_MESSAGE_049 = 49,
        HIPS_MESSAGE_050 = 50,
        HIPS_MESSAGE_051 = 51,
        HIPS_MESSAGE_052 = 52,
        HIPS_MESSAGE_053 = 53,
        HIPS_MESSAGE_054 = 54,
        HIPS_MESSAGE_055 = 55,
        HIPS_MESSAGE_056 = 56,
        HIPS_MESSAGE_057 = 57,
        HIPS_MESSAGE_058 = 58,
        HIPS_MESSAGE_059 = 59,
        HIPS_MESSAGE_060 = 60,
        HIPS_MESSAGE_061 = 61,
        HIPS_MESSAGE_062 = 62,
        HIPS_MESSAGE_063 = 63,
        HIPS_MESSAGE_064 = 64,
        HIPS_MESSAGE_065 = 65,
        HIPS_MESSAGE_066 = 66,
        HIPS_MESSAGE_067 = 67,
        HIPS_MESSAGE_068 = 68,
        HIPS_MESSAGE_069 = 69,
        HIPS_MESSAGE_070 = 70,
        HIPS_MESSAGE_071 = 71,
        HIPS_MESSAGE_072 = 72,
        HIPS_MESSAGE_073 = 73,
        HIPS_MESSAGE_074 = 74,
        HIPS_MESSAGE_075 = 75,
        HIPS_MESSAGE_076 = 76,
        HIPS_MESSAGE_077 = 77,
        HIPS_MESSAGE_078 = 78,
        HIPS_MESSAGE_079 = 79,
        HIPS_MESSAGE_080 = 80,
        HIPS_MESSAGE_081 = 81,
        HIPS_MESSAGE_082 = 82,
        HIPS_MESSAGE_083 = 83,
        HIPS_MESSAGE_084 = 84,
        HIPS_MESSAGE_085 = 85,
        HIPS_MESSAGE_086 = 86,
        HIPS_MESSAGE_087 = 87,
        HIPS_MESSAGE_088 = 88,
        HIPS_MESSAGE_089 = 89,
        HIPS_MESSAGE_090 = 90,
        HIPS_MESSAGE_091 = 91,
        HIPS_MESSAGE_092 = 92,
        HIPS_MESSAGE_093 = 93,
        HIPS_MESSAGE_094 = 94,
        HIPS_MESSAGE_095 = 95,
        HIPS_MESSAGE_096 = 96,
        HIPS_MESSAGE_097 = 97,
        HIPS_MESSAGE_098 = 98,
        HIPS_MESSAGE_099 = 99,
        HIPS_MESSAGE_100 = 100,
        HIPS_MESSAGE_101 = 101,
        HIPS_MESSAGE_102 = 102,
        HIPS_MESSAGE_103 = 103,
        HIPS_MESSAGE_104 = 104,
        HIPS_MESSAGE_105 = 105,
        HIPS_MESSAGE_106 = 106,
        HIPS_MESSAGE_107 = 107,
        HIPS_MESSAGE_108 = 108,
        HIPS_MESSAGE_109 = 109,
        HIPS_MESSAGE_110 = 110,
        HIPS_MESSAGE_111 = 111,
        HIPS_MESSAGE_112 = 112,
        HIPS_MESSAGE_113 = 113,
        HIPS_MESSAGE_114 = 114,
        HIPS_MESSAGE_115 = 115,
        HIPS_MESSAGE_116 = 116,
        HIPS_MESSAGE_117 = 117,
        HIPS_MESSAGE_118 = 118,
        HIPS_MESSAGE_119 = 119,
        HIPS_MESSAGE_120 = 120,
        HIPS_MESSAGE_121 = 121,
        HIPS_MESSAGE_122 = 122,
        HIPS_MESSAGE_123 = 123,
        HIPS_MESSAGE_124 = 124,
        HIPS_MESSAGE_125 = 125,
        HIPS_MESSAGE_126 = 126,
        HIPS_MESSAGE_127 = 127,
        HIPS_MESSAGE_128 = 128,
        HIPS_MESSAGE_129 = 129,
        HIPS_MESSAGE_130 = 130,
        HIPS_MESSAGE_131 = 131,
        HIPS_MESSAGE_132 = 132,
        HIPS_MESSAGE_133 = 133,
        HIPS_MESSAGE_134 = 134,
        HIPS_MESSAGE_135 = 135,
        HIPS_MESSAGE_136 = 136,
        HIPS_MESSAGE_137 = 137,
        HIPS_MESSAGE_138 = 138,
        HIPS_MESSAGE_139 = 139,
        HIPS_MESSAGE_140 = 140,
        HIPS_MESSAGE_141 = 141,
        HIPS_MESSAGE_142 = 142,
        HIPS_MESSAGE_143 = 143,
        HIPS_MESSAGE_144 = 144,
        HIPS_MESSAGE_145 = 145,
        HIPS_MESSAGE_146 = 146,
        HIPS_MESSAGE_147 = 147,
        HIPS_MESSAGE_148 = 148,
        HIPS_MESSAGE_149 = 149,
        HIPS_MESSAGE_150 = 150,
        HIPS_MESSAGE_151 = 151,
        HIPS_MESSAGE_152 = 152,
        HIPS_MESSAGE_153 = 153,
        HIPS_MESSAGE_154 = 154,
        HIPS_MESSAGE_155 = 155,
        HIPS_MESSAGE_156 = 156,

        PUMA_MESSAGE_1001 = 1001,
        PUMA_MESSAGE_1002 = 1002,
        PUMA_MESSAGE_1003 = 1003,
        PUMA_MESSAGE_1004 = 1004,
        PUMA_MESSAGE_1005 = 1005,
        PUMA_MESSAGE_1006 = 1006,
        PUMA_MESSAGE_1007 = 1007,
        PUMA_MESSAGE_1008 = 1008,
        PUMA_MESSAGE_1009 = 1009,
        PUMA_MESSAGE_1010 = 1010,
        PUMA_MESSAGE_1011 = 1011,
        PUMA_MESSAGE_1012 = 1012,
        PUMA_MESSAGE_1013 = 1013,
        PUMA_MESSAGE_1014 = 1014,
        PUMA_MESSAGE_1015 = 1015,
        PUMA_MESSAGE_1016 = 1016,
        PUMA_MESSAGE_1017 = 1017,
        PUMA_MESSAGE_1018 = 1018,
        PUMA_MESSAGE_1019 = 1019,
        PUMA_MESSAGE_1020 = 1020,
        PUMA_MESSAGE_1021 = 1021,
        PUMA_MESSAGE_1022 = 1022,
        PUMA_MESSAGE_1023 = 1023,
        PUMA_MESSAGE_1024 = 1024,
        PUMA_MESSAGE_1025 = 1025,
        PUMA_MESSAGE_1026 = 1026,
        PUMA_MESSAGE_1027 = 1027,
        PUMA_MESSAGE_1028 = 1028,
        PUMA_MESSAGE_1029 = 1029,
        PUMA_MESSAGE_1030 = 1030,
        PUMA_MESSAGE_1031 = 1031,
        PUMA_MESSAGE_1032 = 1032,
        PUMA_MESSAGE_1033 = 1033,
        PUMA_MESSAGE_1034 = 1034
    }
}