﻿namespace HIPS.PcehrDataStore.Schemas.Enumerators
{
    /// <summary>
    /// <para>
    /// A hospital may have many different identifiers associated. Some, like the HPI-O, might be shared
    /// with other hospitals within the same jurisdiction. Others, like the Pathology System might use
    /// more than one identifier for the same hospital.
    /// </para>
    /// <para>
    /// One use of Hospital Identifiers is to identify the assigning authority of the local patient identifier
    /// (Medical Record Number or Unit Record Number) that is sent in the PatientIdentifierList or PatientId of
    /// an HL7 message.
    /// </para>
    /// <para>
    /// Each sending application may use a different set of identifiers to identify the assigning authority
    /// of the local patient identifier (Mrn) that is sent in the PatientIdentifierList or PatientId.
    /// </para>
    /// <para>
    /// The namespace ID corresponding to each of the types below is determined by the
    /// value of the enum. The enum provides a convenient way to reference the required
    /// namespace from the business logic.
    /// </para>
    /// </summary>
    //public enum HospitalIdentifierNamespace
    //{
    //    HealthcareProviderIdentifierForOrganisation = 1,
    //    PatientAdministrationSystem = 2,
    //    PathologySystem = 3,
    //    RadiologySystem = 4,
    //    OidForLocalPatientIdentifier = 5,
    //    OidForLocalDoctorIdentifier = 6,
    //    IntegratedSouthAustralianActivityCollection = 7,
    //    CountryDataMart = 8
    //}
}