﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Clinical Document
    /// </summary>
    [KnownType(typeof(ClinicalDocument))]
    [Serializable]
    [DataContract]
    public class ClinicalDocument : BaseSchema
    {
        #region Private Members

        private string sourceSystemSetId;
        private int episodeId;
        private int documentTypeId;
        private string documentTypeCode;
        private string documentTypeDescription;
        private DateTime? removedDate;
        private int removalReasonId;
        private string removalReasonDescription;
        private int clinicalDocumentStatusId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the Clinical Document id.
        /// </summary>
        /// <value>
        /// The Clinical Document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? ClinicalDocumentId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the source system set id.
        /// </summary>
        /// <value>
        /// The source system set id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SourceSystemSetId
        {
            get
            {
                return sourceSystemSetId;
            }
            set
            {
                sourceSystemSetId = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => SourceSystemSetId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the episode id that this document is related to.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int EpisodeId
        {
            get
            {
                return episodeId;
            }
            set
            {
                episodeId = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => EpisodeId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the document type id.
        /// </summary>
        /// <value>
        /// The document type id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int DocumentTypeId
        {
            get
            {
                return documentTypeId;
            }
            set
            {
                documentTypeId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => DocumentTypeId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the document type description.
        /// </summary>
        /// <value>
        /// The document type description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string DocumentTypeDescription
        {
            get
            {
                return documentTypeDescription;
            }
            set
            {
                documentTypeDescription = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => DocumentTypeDescription);
#endif
            }
        }

        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string DocumentTypeCode
        {
            get
            {
                return documentTypeCode;
            }
            set
            {
                documentTypeCode = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => DocumentTypeCode);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the removed date.
        /// </summary>
        /// <value>
        /// The removed date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? RemovedDate
        {
            get
            {
                return removedDate;
            }
            set
            {
                removedDate = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => RemovedDate);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the removal reason id.
        /// </summary>
        /// <value>
        /// The removal reason id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int RemovalReasonId
        {
            get
            {
                return removalReasonId;
            }
            set
            {
                removalReasonId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => RemovalReasonId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the removal reason description.
        /// </summary>
        /// <value>
        /// The removal reason description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string RemovalReasonDescription
        {
            get
            {
                return removalReasonDescription;
            }
            set
            {
                removalReasonDescription = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => RemovalReasonDescription);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the clinical document status ID.
        ///
        /// See <see cref="HIPS.PcehrDataStore.Schemas.Enumerators.ClinicalDocumentStatus">the ClinicalDocumentStatus enumerator</see> for expected values.
        /// </summary>
        /// <value>
        /// The clinical document status ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int ClinicalDocumentStatusId
        {
            get
            {
                return clinicalDocumentStatusId;
            }
            set
            {
                clinicalDocumentStatusId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => ClinicalDocumentStatusId);
#endif
            }
        }

        #endregion Properties
    }
}