﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Clinical Document Status
    /// </summary>
    [KnownType(typeof(ClinicalDocumentStatus))]
    [Serializable]
    [DataContract]
    public class ClinicalDocumentStatus : BaseListSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the clinical document status id.
        /// </summary>
        /// <value>
        /// The clinical document status id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? ClinicalDocumentStatusId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        #endregion Properties
    }
}