﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a country
    /// </summary>
    [KnownType(typeof(Country))]
    [Serializable]
    [DataContract]
    public class Country : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        /// <value>
        /// The country id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? CountryId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the SACC - Needs to be validated to see if it should be replaced by code.
        /// </summary>
        /// <value>
        /// The SACC.
        /// </value>
        //[DataBaseInfoAttributes(Enumerators.DatabaseColumnType.Data)]
        //public string SACC { get; set; }
    }
}