﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Clinical Document Format. The format code
    /// identifies a set of validation rules applied by the PCEHR to the
    /// uploaded document.
    /// </summary>
    [KnownType(typeof(DocumentFormat))]
    [Serializable]
    [DataContract]
    public class DocumentFormat : BaseCodeListSchema
    {
        #region Fields

        private int codeSystemId;
        private string codeSystemCode;
        private string codeSystemDescription;

        #endregion Fields

        #region Properties

        /// <summary>
        /// Gets or sets the document format id.
        /// </summary>
        /// <value>
        /// The document format id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? DocumentFormatId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the document format code system ID.
        /// </summary>
        /// <value>
        /// The document format code system ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int CodeSystemId
        {
            get
            {
                return codeSystemId;
            }
            set
            {
                codeSystemId = value;
            }
        }

        /// <summary>
        /// Gets or sets the document format code system code. This is used in the upload request.
        /// All document format codes that have been defined as of 11/06/2013 are "PCEHR_FormatCodes".
        /// </summary>
        /// <value>
        /// The document format code system code.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string CodeSystemCode
        {
            get
            {
                return codeSystemCode;
            }
            set
            {
                codeSystemCode = value;
            }
        }

        /// <summary>
        /// Gets or sets the document format code system description.
        /// </summary>
        /// <value>
        /// The document format code system description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string CodeSystemDescription
        {
            get
            {
                return codeSystemDescription;
            }
            set
            {
                codeSystemDescription = value;
            }
        }

        #endregion Properties
    }
}