﻿using System;
using System.Runtime.Serialization;
using System.Linq;
using System.Collections.Generic;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the information of a single health provider organisation (HPI-O).
    /// </summary>
    [KnownType(typeof(HealthProviderOrganisation))]
    [Serializable]
    [DataContract]
    public class HealthProviderOrganisation : BaseCodeListSchema
    {
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthProviderOrganisationId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the HPIO number of the health provider organisation
        /// </summary>
        /// <value>
        /// HPIO Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Hpio { get; set; }

        /// <summary>
        /// Gets or sets the name of the health provider organisation
        /// </summary>
        /// <value>
        /// Name of the health provider organisation
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets The HI Service Certificate Serial Number
        /// This is used to find and obtain the certificate from the certificate store for use in connections to the HI Service
        /// </summary>
        /// <value>
        /// HI Certificate Serial Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HiCertSerial { get; set; }

        /// <summary>
        /// Gets or sets The PCEHR Service Certificate Serial Number
        /// This is used to find and obtain the certificate from the certificate store for use in connections to the PCEHR Service
        /// </summary>[s
        /// <value>
        /// PCEHR Certificate Serial Number
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string PcehrCertSerial { get; set; }

        /// <summary>
        /// Gets or sets The AuthorisedEmployeeName for use with calls that only use the HPIO
        /// </summary>[s
        /// <value>
        /// Authorised Employee Name
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AuthorisedEmployeeName { get; set; }

        /// <summary>
        /// Gets or sets The AuthorisedEmployeeUserId for use with calls that only use the HPIO
        /// </summary>[s
        /// <value>
        /// Authorised Employee User Id passed to service calls
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AuthorisedEmployeeUserId { get; set; }

    }
}