﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the information about a patient that is specific to a single health provider organisation (HPI-O).
    /// </summary>
    [KnownType(typeof(HealthProviderOrganisationPatient))]
    [Serializable]
    [DataContract]
    public class HealthProviderOrganisationPatient : BaseSchema
    {
        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? PatientMasterId { get; set; }

        /// <summary>
        /// Gets or sets the health provider organisation ID.
        /// </summary>
        /// <value>
        /// The health provider organisation ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthProviderOrganisationId { get; set; }

        /// <summary>
        /// Gets or sets whether the PCEHR was advertised when this HPI-O called doesPCEHRExist.
        /// If the PCEHR is advertised to this HPI-O, then the hospitals that use this HPI-O
        /// should send discharge summaries for upload to PCEHR.
        /// </summary>
        /// <value>
        /// Whether the PCEHR was advertised.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool? PcehrAdvertised { get; set; }

        /// <summary>
        /// Gets or sets whether an access code is required for this HPI-O to access this patient's PCEHR, or this HPI-O has already gained access.
        /// </summary>
        /// <value>
        /// Whether an access code is required.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int AccessCodeRequiredId { get; set; }

        /// <summary>
        /// Gets or sets whether the patient has disclosed the existence of a PCEHR to this HPI-O.
        /// If the patient has disclosed the existence of a PCEHR to this HPI-O, then the hospitals
        /// that use this HPI-O should send discharge summaries for upload to PCEHR.
        /// </summary>
        /// <value>
        /// Whether the patient has disclosed the existence of a PCEHR to this HPI-O.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool PcehrDisclosed { get; set; }
    }
}