﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a hospital code (e.g. HPI-O, ISAAC, CDM, HL7 PAS, Pathology).
    /// Each hospital can have codes of multiple types, and can even have more than one code of each identifier.
    /// The identifier is represented by a namespace.
    /// </summary>
    [KnownType(typeof(HospitalCode))]
    [Serializable]
    [DataContract]
    public class HospitalCode : BaseSchema
    {
        /// <summary>
        /// Gets or sets the hospital code id.
        /// </summary>
        /// <value>
        /// The hospital code id.
        /// </value>
        [DataMember]
        public int? HospitalCodeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the hospital.
        /// </summary>
        /// <value>
        /// The hospital.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the code system id.
        /// </summary>
        /// <value>
        /// The code system id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int CodeSystemId { get; set; }

        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        /// <value>
        /// The code.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Code { get; set; }

        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string CodeSystemCode { get; set; }
    }
}