﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a patient within a particular hospital, and does
    /// not contain the full details of the patient (for that, see the <see
    /// cref="HIPS.PcehrDataStore.Schemas.PatientMaster">PatientMaster</see>
    /// class).
    /// </summary>
    [KnownType(typeof(HospitalPatient))]
    [Serializable]
    [DataContract]
    public class HospitalPatient : BaseSchema
    {
        /// <summary>
        /// Gets or sets the patient  ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? PatientId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int PatientMasterId { get; set; }

        /// <summary>
        /// Gets or sets the hospital ID.
        /// </summary>
        /// <value>
        /// The hospital ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the Medical Record Number (MRN) allocated by the
        /// hospital PAS to identify this patient.
        /// </summary>
        /// <value>
        /// The Mrn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Mrn { get; set; }
    }
}