﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;
using HIPS.HpiiSchemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{

    /// <summary>
    /// This class represents an audit record for an HPII lookup
    /// </summary>
    [KnownType(typeof(HpiiLookupAudit))]
    [Serializable]
    [DataContract]
    public class HpiiLookupAudit : BaseSchema
    {
        #region private members

        private string request;
        private string response;

        #endregion private members

        #region Constructor

        public HpiiLookupAudit()
        {
            HpiiStatusId = (int)HpiiStatus.Undefined;
        }

        #endregion Constructor

        /// <summary>
        /// Gets or sets the HPII lookup audit ID.
        /// </summary>
        /// <value>
        /// The hpii lookup audit ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? HpiiLookupAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or Sets the Hpii Number
        /// </summary>
        /// <value>
        /// The Hpii Number 
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiiNumber { get; set; }

        /// <summary>
        /// Gets or Sets the Hpii StatusId
        /// </summary>
        /// <value>
        /// The Hpii StatusId
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? HpiiStatusId { get; set; }
        
        /// <summary>
        /// Gets or Sets the Registration Id
        /// </summary>
        /// <value>
        /// The Registration Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string RegistrationId { get; set; }

        /// <summary>
        /// Gets or Sets the Family Name 
        /// </summary>
        /// <value>
        /// The Family Name 
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or Sets the Given Names
        /// </summary>
        /// <value>
        /// The Given Names
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or Sets the Date Of Birth
        /// </summary>
        /// <value>
        /// The Date Of Birth
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or Sets the Sex Id
        /// </summary>
        /// <value>
        /// The Sex Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Sex { get; set; }

        /// <summary>
        /// Gets or Sets the Australian State Id
        /// </summary>
        /// <value>
        /// The Australian State Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string AustralianState { get; set; }

        /// <summary>
        /// Gets or Sets the Postcode
        /// </summary>
        /// <value>
        /// The Postcode
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Postcode { get; set; }

        /// <summary>
        /// Gets or Sets the Country Id
        /// </summary>
        /// <value>
        /// The Country Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or Sets the Batch Item Id
        /// </summary>
        /// <value>
        /// The Batch Item Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? BatchItemId { get; set; }

        /// <summary>
        /// Gets or Sets the Batch Id
        /// </summary>
        /// <value>
        /// The Batch Id
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? BatchId { get; set; }

        /// <summary>
        /// Gets or Sets the Message
        /// </summary>
        /// <value>
        /// The Message
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Message { get; set; }

        /// <summary>
        /// Gets or Sets the Operator HpiI
        /// </summary>
        /// <value>
        /// The Operator HpiI
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string OperatorHpiI { get; set; }

        /// <summary>
        /// Gets or Sets the HpiO
        /// </summary>
        /// <value>
        /// The HpiO
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiO { get; set; }

        /// <summary>
        /// Gets or Sets the Operator
        /// </summary>
        /// <value>
        /// The Operator
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Operator { get; set; }

        /// <summary>
        /// Gets or Sets the Identifier Type of the local identifier related to the search
        /// </summary>
        /// <value>
        /// The Identifier Type
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string IdentifierType { get; set; }

        /// <summary>
        /// Gets or Sets the Identifier Value of the local identifier related to the search
        /// </summary>
        /// <value>
        /// The Identifier Value
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string IdentifierValue { get; set; }

        /// <summary>
        /// Gets or Sets the Hi Web Service Name
        /// </summary>
        /// <value>
        /// The Hi Web Service Name
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HiWebServiceName { get; set; }

        /// <summary>
        /// Gets or Sets the Hi Web Service Version
        /// </summary>
        /// <value>
        /// The Hi Web Service Version
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HiWebServiceVersion { get; set; }
        
        /// <summary>
        /// Gets or Sets the ServiceMessageRequestID
        /// </summary>
        /// <value>
        /// The ServiceMessageRequestID
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string ServiceMessageRequestID { get; set; }

        /// <summary>
        /// Gets or Sets the ServiceMessageResponseID
        /// </summary>
        /// <value>
        /// The ServiceMessageResponseID
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string ServiceMessageResponseID { get; set; }
        
        /// <summary>
        /// Gets or sets the request
        /// </summary>
        /// <value>
        /// The request
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Request
        {
            get
            {
                return this.request;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.request = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.request = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the response
        /// </summary>
        /// <value>
        /// The response
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Response
        {
            get
            {
                return this.response;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.response = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.response = value;
                }
            }
        }
    }
}
