﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an audit record for an IHI lookup
    /// </summary>
    [KnownType(typeof(IhiLookupAudit))]
    [Serializable]
    [DataContract]
    public class IhiLookupAudit : BaseSchema
    {
        #region private members

        private string request;
        private string response;

        #endregion private members

        #region Constructor

        public IhiLookupAudit()
        {
            IhiRecordStatus = (int)HIPS.PcehrDataStore.Schemas.Enumerators.IhiRecordStatus.Unknown;
            IhiStatus = (int)HIPS.PcehrDataStore.Schemas.Enumerators.IhiStatus.Unknown;
        }

        #endregion Constructor

        /// <summary>
        /// Gets or sets the IHI lookup audit ID.
        /// </summary>
        /// <value>
        /// The ihi lookup audit ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? IhiLookupAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int PatientMasterId { get; set; }

        /// <summary>
        /// Gets or sets the sequence number.
        /// </summary>
        /// <value>
        /// The sequence number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int SequenceNumber { get; set; }

        /// <summary>
        /// Gets or sets the ihi number.
        /// </summary>
        /// <value>
        /// The ihi number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string IhiNumber { get; set; }

        /// <summary>
        /// Gets or sets the ihi status.
        /// </summary>
        /// <value>
        /// The ihi status.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int IhiStatus { get; set; }

        /// <summary>
        /// Gets or sets the ihi record status.
        /// </summary>
        /// <value>
        /// The ihi record status.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int IhiRecordStatus { get; set; }

        /// <summary>
        /// Gets or sets the name of the family.
        /// </summary>
        /// <value>
        /// The name of the family.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the given.
        /// </summary>
        /// <value>
        /// The name of the given.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string GivenName { get; set; }

        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        /// <value>
        /// The sex.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int SexID { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the medicare number.
        /// </summary>
        /// <value>
        /// The medicare number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// Gets or sets the dva number.
        /// </summary>
        /// <value>
        /// The dva number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string DvaNumber { get; set; }

        /// <summary>
        /// Gets or sets the message returned back from the IHI lookup service.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the HPI-I.
        /// </summary>
        /// <value>
        /// The hpi I.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiI { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O.
        /// </summary>
        /// <value>
        /// The hpi O.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiO { get; set; }

        /// <summary>
        /// Gets or sets the responsible officer.
        /// </summary>
        /// <value>
        /// The responsible officer.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Operator { get; set; }

        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Request
        {
            get
            {
                return this.request;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.request = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.request = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the response.
        /// </summary>
        /// <value>
        /// The response.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Response
        {
            get
            {
                return this.response;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.response = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.response = value;
                }
            }
        }
    }
}