﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents a patient with an IHI but without a recorded PCEHR.
    /// </summary>
    [DataContract]
    public class PatientWithoutPcehr
    {
        /// <summary>
        /// The patients master identifier
        /// </summary>
        public int PatientMasterId { get; set; }

        /// <summary>
        /// The patients's IHI.
        /// </summary>
        [DataMember]
        public string Ihi { get; set; }

        /// <summary>
        /// The patients's IHI status.
        /// </summary>
        public int IhiStatusId { get; set; }

        /// <summary>
        /// The patients's IHI status.
        /// </summary>
        [DataMember]
        public IhiStatus IhiStatus 
        { 
            get
            {
                return (IhiStatus) IhiStatusId;
            }
            set
            {
                IhiStatusId = (int) value;
            }
        }

        /// <summary>
        /// The patients's IHI record status.
        /// </summary>
        public int IhiRecordStatusId { get; set; }

        /// <summary>
        /// The patients's IHI record status.
        /// </summary>
        [DataMember]
        public IhiRecordStatus IhiRecordStatus
        {
            get
            {
                return (IhiRecordStatus) IhiRecordStatusId;
            }
            set
            {
                IhiRecordStatusId = (int) value;
            }
        }

        /// <summary>
        /// The patients's IHI last validated date.
        /// </summary>
        [DataMember]
        public DateTime DateLastValidated { get; set; }

        /// <summary>
        /// The patients's Date of Birth.
        /// </summary>
        [DataMember]
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// The patients's Medicare Number.
        /// </summary>
        [DataMember]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// The patients's Medicare Irn.
        /// </summary>
        [DataMember]
        public string MedicareIrn { get; set; }

        /// <summary>
        /// The patients's DVA Number.
        /// </summary>
        [DataMember]
        public string DVANumber { get; set; }

        /// <summary>
        /// The patients's current sex identifier.
        /// </summary>
        public int CurrentSexId { get; set; }

        /// <summary>
        /// The patients's current sex.
        /// </summary>
        [DataMember]
        public SexEnumerator Sex
        {
            get
            {
                return (SexEnumerator) CurrentSexId;
            }
            set
            {
                CurrentSexId = (int)value;
            }
        }

        /// <summary>
        /// The patients's family name.
        /// </summary>
        [DataMember]
        public string FamilyName { get; set; }

        /// <summary>
        /// The patient's given names.
        /// </summary>
        [DataMember]
        public string GivenNames { get; set; }

                /// <summary>
        /// The patients's Medicare registered sex identifier.
        /// </summary>
        public int RegisteredSexId { get; set; }

        /// <summary>
        /// The patients's current sex.
        /// </summary>
        [DataMember]
        public SexEnumerator RegisteredSex
        {
            get
            {
                return (SexEnumerator)RegisteredSexId;
            }
            set
            {
                RegisteredSexId = (int)value;
            }
        }

        /// <summary>
        /// The patients's Medicare registered family name.
        /// </summary>
        [DataMember]
        public string RegisteredFamilyName { get; set; }

        /// <summary>
        /// The patient's Medicare registered given name.
        /// </summary>
        [DataMember]
        public string RegisteredGivenName { get; set; }

        /// <summary>
        /// The patient's name suffixes (like "Jr")
        /// </summary>
        [DataMember]
        public string Suffix { get; set; }

        /// <summary>
        /// The patients's titles (like "Dr", "Ms" or "Mr")
        /// </summary>
        [DataMember]
        public string Title { get; set; }

        /// <summary>
        /// The current Hospital of the patient.
        /// </summary>
        public int HospitalId { get; set; }

        /// <summary>
        /// The current Hospital code of the patient.
        /// </summary>
        [DataMember]
        public string HospitalCode { get; set; }

        /// <summary>
        /// The current Ward of the patient.
        /// </summary>
        [DataMember]
        public string Ward { get; set; }

        /// <summary>
        /// The current Room of the patient.
        /// </summary>
        [DataMember]
        public string Room { get; set; }

        /// <summary>
        /// The current Bed of the patient.
        /// </summary>
        [DataMember]
        public string Bed { get; set; }

    }
}
