﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an audit record for a PCEHR service invocation
    /// </summary>
    [KnownType(typeof(PcehrAudit))]
    [Serializable]
    [DataContract]
    public class PcehrAudit : BaseSchema
    {
        #region private members

        private string request;
        private string response;

        #endregion private members

        /// <summary>
        /// Gets or sets the PCEHR audit ID.
        /// </summary>
        /// <value>
        /// The PCEHR audit ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? PcehrAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int PatientMasterId { get; set; }

        /// <summary>
        /// Gets or sets the service name.
        /// </summary>
        /// <value>
        /// The service name.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string ServiceName { get; set; }

        /// <summary>
        /// Gets or sets the service message.
        /// </summary>
        /// <value>
        /// The service message.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string ServiceMessage { get; set; }

        /// <summary>
        /// Gets or sets the SOAP request.
        /// </summary>
        /// <value>
        /// The SOAP request.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Request
        {
            get
            {
                return this.request;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.request = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.request = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the SOAP response.
        /// </summary>
        /// <value>
        /// The SOAP response.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Response
        {
            get
            {
                return this.response;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.response = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.response = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the IHI.
        /// </summary>
        /// <value>
        /// The IHI.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Ihi { get; set; }

        /// <summary>
        /// Gets or sets the HPI-O.
        /// </summary>
        /// <value>
        /// The HPI-O.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiO { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        /// <value>
        /// The user name.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string UserName { get; set; }
    }
}