﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents queued operation for a PCEHR service invocation
    /// </summary>
    [KnownType(typeof(PcehrMessageQueue))]
    [Serializable]
    [DataContract]
    public class PcehrMessageQueue : BaseSchema
    {
        #region private members

        private string request;
        private string response;

        #endregion private members

        /// <summary>
        /// Gets or sets the primary key for the PCEHR message queue object.
        /// </summary>
        /// <value>
        /// The PCEHR message queue ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? PcehrMessageQueueId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the queue operation ID.
        /// </summary>
        /// <value>
        /// The queue operation ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int QueueOperationId { get; set; }

        /// <summary>
        /// Gets or sets the queue operation name.
        /// </summary>
        /// <value>
        /// The queue operation name.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string QueueOperationName { get; set; }

        /// <summary>
        /// Gets or sets the queue status ID.
        /// </summary>
        /// <value>
        /// The queue status ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int QueueStatusId { get; set; }

        /// <summary>
        /// Gets or sets the queue status description.
        /// </summary>
        /// <value>
        /// The queue status description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string QueueStatusDescription { get; set; }

        /// <summary>
        /// Gets or sets the episode ID.
        /// </summary>
        /// <value>
        /// The episode ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int EpisodeId { get; set; }

        /// <summary>
        /// Gets or sets the SourceSystemSet ID.
        /// </summary>
        /// <value>
        /// The SourceSystemSet ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SourceSystemSetId { get; set; }

        /// <summary>
        /// Gets or sets the SourceSystemDocument ID.
        /// </summary>
        /// <value>
        /// The SourceSystemDocument ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SourceSystemDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the serialised object.
        /// </summary>
        /// <value>
        /// The serialised object.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public byte[] SerialisedObject { get; set; }

        /// <summary>
        /// Gets or sets the SOAP request.
        /// </summary>
        /// <value>
        /// The SOAP request.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Request
        {
            get
            {
                return this.request;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.request = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.request = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the SOAP response.
        /// </summary>
        /// <value>
        /// The SOAP response.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Response
        {
            get
            {
                return this.response;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.response = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.response = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the error details and stack trace.
        /// </summary>
        /// <value>
        /// The error details and stack trace.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Details { get; set; }
    }
}