﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an audit record for the authoring institution's removal of a document from the PCEHR system.
    /// </summary>
    [KnownType(typeof(RemoveAudit))]
    [Serializable]
    [DataContract]
    public class RemoveAudit : BaseSchema
    {
        #region Properties

        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? RemoveAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the clinical document id.
        /// </summary>
        /// <value>
        /// The clinical document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int ClinicalDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the removal reason id.
        /// </summary>
        /// <value>
        /// The removal reason id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int RemovalReasonId { get; set; }

        /// <summary>
        /// Gets or sets the removal reason description.
        /// </summary>
        /// <value>
        /// The removal reason description.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string RemovalReasonDescription { get; set; }

        /// <summary>
        /// Gets or sets the additional audit information, such as a scanned image of the form that the author (or delegate) signed.
        /// </summary>
        /// <value>
        /// The audit information.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public byte[] AuditInformation { get; set; }

        #endregion Properties
    }
}