--Copyright Philip Stalley-Gordon 2013
DECLARE @name VARCHAR(128)
DECLARE @SQL VARCHAR(254)
DECLARE @schema VARCHAR(128)
DECLARE @constraint VARCHAR(254)

/* Drop user stored procs */
SELECT  @name = ( SELECT TOP 1
							QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
							+ QUOTENAME(name) AS name
				  FROM      sys.procedures
				  ORDER BY  schema_id ,
							name
				)
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'DROP PROCEDURE ' + RTRIM(@name)
		PRINT @SQL
		EXEC (@SQL)
		PRINT 'Dropped Procedure: ' + @name
		SELECT  @name = ( SELECT TOP 1
									QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
									+ QUOTENAME(name) AS name
						  FROM      sys.procedures
						  ORDER BY  schema_id ,
									name
						)
	END
SET @SQL = NULL
SET @name = NULL

/* Drop views */
SELECT  @name = ( SELECT TOP 1
							QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
							+ QUOTENAME(name) AS name
				  FROM      sys.views
				  ORDER BY  schema_id ,
							name
				)
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'DROP VIEW ' + RTRIM(@name)
		PRINT @SQL
		EXEC (@SQL)
		PRINT 'Dropped View: ' + @name
		SELECT  @name = ( SELECT TOP 1
									QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
									+ QUOTENAME(name) AS name
						  FROM      sys.views
						  ORDER BY  schema_id ,
									name
						)
	END
SET @SQL = NULL
SET @name = NULL


/* Drop functions */
SELECT  @name = ( SELECT TOP 1
							SPECIFIC_SCHEMA + '.' + SPECIFIC_NAME
				  FROM      INFORMATION_SCHEMA.ROUTINES
				  WHERE     ROUTINE_TYPE = 'FUNCTION'
				  ORDER BY  SPECIFIC_SCHEMA ,
							SPECIFIC_NAME
				)
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'DROP FUNCTION ' + RTRIM(@name)
		PRINT @SQL
		EXEC (@SQL)
		PRINT 'Dropped Function: ' + @name
		SELECT  @name = ( SELECT TOP 1
									SPECIFIC_SCHEMA + '.' + SPECIFIC_NAME
						  FROM      INFORMATION_SCHEMA.ROUTINES
						  WHERE     ROUTINE_TYPE = 'FUNCTION'
						  ORDER BY  SPECIFIC_SCHEMA ,
									SPECIFIC_NAME
						)
	END
SET @SQL = NULL
SET @name = NULL

/* Drop Foreign Key constraints */
SELECT TOP 1
		@name = TABLE_NAME ,
		@schema = TABLE_SCHEMA ,
		@constraint = CONSTRAINT_NAME
FROM    INFORMATION_SCHEMA.TABLE_CONSTRAINTS
WHERE   constraint_catalog = DB_NAME()
		AND CONSTRAINT_TYPE = 'FOREIGN KEY'
ORDER BY TABLE_SCHEMA ,
		TABLE_NAME
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'ALTER TABLE ' + RTRIM(@schema) + '.' + RTRIM(@name)
				+ ' DROP CONSTRAINT ' + RTRIM(@constraint)
		PRINT @SQL
		BEGIN TRANSACTION
		EXEC (@SQL)
		COMMIT TRANSACTION
		PRINT 'Dropped FK Constraint: ' + @constraint + ' on ' + @schema + '.'
			+ @name
		SET @name = NULL
		SELECT TOP 1
				@name = TABLE_NAME ,
				@schema = TABLE_SCHEMA ,
				@constraint = CONSTRAINT_NAME
		FROM    INFORMATION_SCHEMA.TABLE_CONSTRAINTS
		WHERE   constraint_catalog = DB_NAME()
				AND CONSTRAINT_TYPE = 'FOREIGN KEY'
		ORDER BY TABLE_SCHEMA ,
				TABLE_NAME
	END
SET @SQL = NULL
SET @name = NULL
SET @schema = NULL
SET @constraint = NULL

/* Drop Primary Key constraints */
SELECT TOP 1
		@name = TABLE_NAME ,
		@schema = TABLE_SCHEMA ,
		@constraint = CONSTRAINT_NAME
FROM    INFORMATION_SCHEMA.TABLE_CONSTRAINTS
WHERE   constraint_catalog = DB_NAME()
		AND CONSTRAINT_TYPE = 'PRIMARY KEY'
ORDER BY TABLE_SCHEMA ,
		TABLE_NAME
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'ALTER TABLE ' + RTRIM(@schema) + '.' + RTRIM(@name)
				+ ' DROP CONSTRAINT ' + RTRIM(@constraint)
		PRINT @SQL
		BEGIN TRANSACTION
		EXEC (@SQL)
		COMMIT TRANSACTION
		PRINT 'Dropped PK Constraint: ' + @constraint + ' on ' + @schema + '.'
			+ @name
		SET @name = NULL
		SELECT TOP 1
				@name = TABLE_NAME ,
				@schema = TABLE_SCHEMA ,
				@constraint = CONSTRAINT_NAME
		FROM    INFORMATION_SCHEMA.TABLE_CONSTRAINTS
		WHERE   constraint_catalog = DB_NAME()
				AND CONSTRAINT_TYPE = 'PRIMARY KEY'
		ORDER BY TABLE_SCHEMA ,
				TABLE_NAME
	END
SET @SQL = NULL
SET @name = NULL
SET @schema = NULL
SET @constraint = NULL

/* Drop user defined table types */
SELECT  @name = ( SELECT TOP 1
							QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
							+ QUOTENAME(name) AS name
				  FROM      sys.types
				  WHERE     is_table_type = 1
				  ORDER BY  schema_id ,
							name
				)
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'DROP TYPE ' + RTRIM(@name) + ''
		PRINT @SQL
		EXEC (@SQL)
		PRINT 'Dropped Type: ' + @name
		SELECT  @name = ( SELECT TOP 1
									QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
									+ QUOTENAME(name) AS name
						  FROM      sys.types
						  WHERE     is_table_type = 1
						  ORDER BY  schema_id ,
									name
						)
	END
SET @SQL = NULL
SET @name = NULL


/* Drop tables */
SELECT  @name = ( SELECT TOP 1
							QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
							+ QUOTENAME(name) AS name
				  FROM      sys.tables
				  ORDER BY  schema_id ,
							name
				)
WHILE @name IS NOT NULL 
	BEGIN
		SELECT  @SQL = 'DROP TABLE ' + RTRIM(@name) + ''
		PRINT @SQL
		EXEC (@SQL)
		PRINT 'Dropped Table: ' + @name
		SELECT  @name = ( SELECT TOP 1
									QUOTENAME(SCHEMA_NAME(schema_id)) + '.'
									+ QUOTENAME(name) AS name
						  FROM      sys.tables
						  ORDER BY  schema_id ,
									name
						)
	END
SET @SQL = NULL
SET @name = NULL
GO


DECLARE @RoleName SYSNAME
SET @RoleName = N'MonitoringRole'

BEGIN
	DECLARE @RoleMemberName SYSNAME
	DECLARE Member_Cursor CURSOR
	FOR
		SELECT  [name]
		FROM    sys.database_principals
		WHERE   principal_id IN (
				SELECT  member_principal_id
				FROM    sys.database_role_members
				WHERE   role_principal_id IN (
						SELECT  principal_id
						FROM    sys.database_principals
						WHERE   [name] = @RoleName
								AND type = 'R' ) )

	OPEN Member_Cursor;

	FETCH NEXT FROM Member_Cursor
	INTO @RoleMemberName

	WHILE @@FETCH_STATUS = 0 
		BEGIN

			EXEC sp_droprolemember @rolename = @RoleName,
				@membername = @RoleMemberName

			FETCH NEXT FROM Member_Cursor
		INTO @RoleMemberName
		END;

	CLOSE Member_Cursor;
	DEALLOCATE Member_Cursor;
END

GO
DROP ROLE [MonitoringRole]
GO
DECLARE @RoleName SYSNAME
SET @RoleName = N'RunStoredProcedure'
BEGIN
	DECLARE @RoleMemberName SYSNAME
	DECLARE Member_Cursor CURSOR
	FOR
		SELECT  [name]
		FROM    sys.database_principals
		WHERE   principal_id IN (
				SELECT  member_principal_id
				FROM    sys.database_role_members
				WHERE   role_principal_id IN (
						SELECT  principal_id
						FROM    sys.database_principals
						WHERE   [name] = @RoleName
								AND type = 'R' ) )

	OPEN Member_Cursor;

	FETCH NEXT FROM Member_Cursor
	INTO @RoleMemberName

	WHILE @@FETCH_STATUS = 0 
		BEGIN

			EXEC sp_droprolemember @rolename = @RoleName,
				@membername = @RoleMemberName

			FETCH NEXT FROM Member_Cursor
		INTO @RoleMemberName
		END;

	CLOSE Member_Cursor;
	DEALLOCATE Member_Cursor;
END
GO

DROP ROLE [RunStoredProcedure]
GO