﻿SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

GO
BEGIN TRANSACTION
GO

-- ========================================================
-- Creates and inserts data in the Repository table
-- Inserts data in the DocumentType table
-- Alters the DocumentType Table to add in the RepositoryId
-- ========================================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

--------------------------
-- Create repository table
--------------------------

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Repository]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Repository](
    [RepositoryId] [int] NOT NULL,
    [Description] [varchar](50) NOT NULL,
    [RepositoryUniqueId] [varchar](100) NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Repository] PRIMARY KEY CLUSTERED 
(
    [RepositoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. PCEHR, NPDR)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', N'COLUMN',N'RepositoryUniqueId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'AThe OID that identifies the repository' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository', @level2type=N'COLUMN',@level2name=N'RepositoryUniqueId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an XDS.b repository to which HIPS can upload and remove documents' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository'
GO

-------------------------
-- Insert repository data
-------------------------

IF NOT EXISTS (SELECT * FROM hips.Repository WHERE RepositoryId = 1)
BEGIN
    INSERT hips.Repository 
        ([RepositoryId]
        ,[Description]
        ,[RepositoryUniqueId]
        ,[DateCreated]
        ,[UserCreated]
        ,[DateModified]
        ,[UserModified])
    VALUES
        (1
        ,'PCEHR'
        ,NULL
        ,GETDATE()
        ,'HIPS'
        ,GETDATE()
        ,'HIPS')  
END

IF NOT EXISTS (SELECT * FROM hips.Repository WHERE RepositoryId = 2)
BEGIN
    INSERT hips.Repository 
        ([RepositoryId]
        ,[Description]
        ,[RepositoryUniqueId]
        ,[DateCreated]
        ,[UserCreated]
        ,[DateModified]
        ,[UserModified])
    VALUES
        (2
        ,'NPDR'
        ,'1.2.36.1.2001.1007.10.8003640002000068'
        ,GETDATE()
        ,'HIPS'
        ,GETDATE()
        ,'HIPS')  
END

----------------------------
-- Alter document type table
----------------------------

IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'RepositoryId' and object_id = OBJECT_ID(N'[hips].[DocumentType]'))
BEGIN
    ALTER TABLE [hips].DocumentType ADD RepositoryId int NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentType_Repository]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentType]'))
ALTER TABLE [hips].[DocumentType]  WITH CHECK ADD  CONSTRAINT [FK_DocumentType_Repository] FOREIGN KEY([RepositoryId])
REFERENCES [hips].[Repository] ([RepositoryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentType_Repository]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentType]'))
ALTER TABLE [hips].[DocumentType] CHECK CONSTRAINT [FK_DocumentType_Repository]
GO

----------------------------
-- Insert document type data
----------------------------

UPDATE hips.DocumentType SET RepositoryId = 1
GO

SET IDENTITY_INSERT [hips].[DocumentType] ON
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 1, 'PCEHR Prescription Record', '100.16764', '2013-12-10 00:00:00.000', 'HIPS', '2013-12-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 1, 'PCEHR Dispense Record', '100.16765', '2013-12-10 00:00:00.000', 'HIPS', '2013-12-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 1, 'Event Summary', '34133-9', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 1, 'Specialist Letter', '51852-2', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 1, 'Shared Health Summary', '60591-5', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[DocumentType] OFF


--Set column to Not Nullable
ALTER TABLE hips.DocumentType ALTER COLUMN RepositoryId int NOT NULL
GO



-- =============================================
-- Updates the HealthProviderOrgansaition Table to add in the AuthorisedEmployeeName
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO


IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'AuthorisedEmployeeNam' and object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]'))
BEGIN
    ALTER TABLE [hips].HealthProviderOrganisation ADD [AuthorisedEmployeeName] [varchar](100) NULL
END

IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'AuthorisedEmployeeUserId' and object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]'))
BEGIN
    ALTER TABLE [hips].HealthProviderOrganisation ADD [AuthorisedEmployeeUserId] [varchar](30) NULL
END


EXEC sp_addextendedproperty N'MS_Description', N'User Name of the Authorised Employee for this HPIO.', 'SCHEMA', N'hips', 'TABLE', N'HealthProviderOrganisation', 'COLUMN', N'AuthorisedEmployeeName'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the Authorised Employee for this HPIO.', 'SCHEMA', N'hips', 'TABLE', N'HealthProviderOrganisation', 'COLUMN', N'AuthorisedEmployeeUserId'
GO

-- ========================================================
-- Alters the HealthProviderOrganisation Table to add in the VisitorHospitalId
-- ========================================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'VisitorHospitalId' and object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]'))
BEGIN
    ALTER TABLE [hips].HealthProviderOrganisation ADD VisitorHospitalId int NULL
END
GO

EXEC sp_addextendedproperty N'MS_Description', N'Hospital Id related to the visitor hospital.', 'SCHEMA', N'hips', 'TABLE', N'HealthProviderOrganisation', 'COLUMN', N'VisitorHospitalId'
GO


--UPDATE new VALUES FOR ALL HPIO records in HealthProviderOrganisation

UPDATE [hips].[HealthProviderOrganisation] 
SET [AuthorisedEmployeeName] = 'OMO'
, [AuthorisedEmployeeUserId] = 'AEUID'
WHERE [HealthProviderOrganisationId] = 1

UPDATE [hips].[HealthProviderOrganisation] 
SET [AuthorisedEmployeeName] = 'OMO'
, [AuthorisedEmployeeUserId] = 'AEUID'
WHERE [HealthProviderOrganisationId] = 2

--Add in new HPII Reference Tables

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[CountryCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[CountryCode](
    [CountryId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_CountryCode] PRIMARY KEY CLUSTERED 
(
    [CountryId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'CountryCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'CountryCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode]  WITH CHECK ADD  CONSTRAINT [FK_CountryCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode] CHECK CONSTRAINT [FK_CountryCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode]  WITH CHECK ADD  CONSTRAINT [FK_CountryCode_Country] FOREIGN KEY([CountryId])
REFERENCES [hips].[Country] ([CountryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_CountryCode_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[CountryCode]'))
ALTER TABLE [hips].[CountryCode] CHECK CONSTRAINT [FK_CountryCode_Country]
GO



SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[LevelType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[LevelType](
    [LevelTypeId] [int] IDENTITY(1,1) NOT NULL,
    [Code] [char](4) NOT NULL,
    [Description] [varchar](256) NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LevelType] PRIMARY KEY CLUSTERED 
(
    [LevelTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'LevelTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a LevelType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'LevelTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[LevelTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[LevelTypeCode](
    [LevelTypeId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LevelTypeCode] PRIMARY KEY CLUSTERED 
(
    [LevelTypeId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'LevelTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'LevelType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'LevelTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LevelTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LevelTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_LevelTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode] CHECK CONSTRAINT [FK_LevelTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_LevelType]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_LevelTypeCode_LevelType] FOREIGN KEY([LevelTypeId])
REFERENCES [hips].[LevelType] ([LevelTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_LevelTypeCode_LevelType]') AND parent_object_id = OBJECT_ID(N'[hips].[LevelTypeCode]'))
ALTER TABLE [hips].[LevelTypeCode] CHECK CONSTRAINT [FK_LevelTypeCode_LevelType]
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PostalDeliveryType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PostalDeliveryType](
    [PostalDeliveryTypeId] [int] IDENTITY(1,1) NOT NULL,
    [Code] [varchar](12) NOT NULL,
    [Description] [varchar](256) NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PostalDeliveryType] PRIMARY KEY CLUSTERED 
(
    [PostalDeliveryTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'PostalDeliveryTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a PostalDeliveryType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'PostalDeliveryTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[PostalDeliveryTypeCode](
    [PostalDeliveryTypeId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_PostalDeliveryTypeCode] PRIMARY KEY CLUSTERED 
(
    [PostalDeliveryTypeId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'PostalDeliveryTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PostalDeliveryType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'PostalDeliveryTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'PostalDeliveryTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'PostalDeliveryTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_PostalDeliveryTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode] CHECK CONSTRAINT [FK_PostalDeliveryTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_PostalDeliveryType]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType] FOREIGN KEY([PostalDeliveryTypeId])
REFERENCES [hips].[PostalDeliveryType] ([PostalDeliveryTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_PostalDeliveryTypeCode_PostalDeliveryType]') AND parent_object_id = OBJECT_ID(N'[hips].[PostalDeliveryTypeCode]'))
ALTER TABLE [hips].[PostalDeliveryTypeCode] CHECK CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType]
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[SexCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[SexCode](
    [SexId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [CodeOverride] [varchar](20) NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_SexCode] PRIMARY KEY CLUSTERED 
(
    [SexId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'SexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Sex' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'SexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'CodeOverride'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Overrides the sex code in this code system' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'CodeOverride'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'SexCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'SexCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode]  WITH CHECK ADD  CONSTRAINT [FK_SexCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode] CHECK CONSTRAINT [FK_SexCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode]  WITH CHECK ADD  CONSTRAINT [FK_SexCode_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SexCode_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[SexCode]'))
ALTER TABLE [hips].[SexCode] CHECK CONSTRAINT [FK_SexCode_Sex]
GO



SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StateCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StateCode](
    [StateId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StateCode] PRIMARY KEY CLUSTERED 
(
    [StateId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'StateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'State' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'StateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StateCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StateCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode]  WITH CHECK ADD  CONSTRAINT [FK_StateCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode] CHECK CONSTRAINT [FK_StateCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_State]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode]  WITH CHECK ADD  CONSTRAINT [FK_StateCode_State] FOREIGN KEY([StateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StateCode_State]') AND parent_object_id = OBJECT_ID(N'[hips].[StateCode]'))
ALTER TABLE [hips].[StateCode] CHECK CONSTRAINT [FK_StateCode_State]
GO



SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetType](
    [StreetTypeId] [int] IDENTITY(1,1) NOT NULL,
    [Code] [char](4) NOT NULL,
    [Description] [varchar](256) NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetType] PRIMARY KEY CLUSTERED 
(
    [StreetTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'StreetTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a StreetType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'StreetTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetTypeCode](
    [StreetTypeId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetTypeCode] PRIMARY KEY CLUSTERED 
(
    [StreetTypeId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'StreetTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StreetType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'StreetTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode] CHECK CONSTRAINT [FK_StreetTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_StreetType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetTypeCode_StreetType] FOREIGN KEY([StreetTypeId])
REFERENCES [hips].[StreetType] ([StreetTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetTypeCode_StreetType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetTypeCode]'))
ALTER TABLE [hips].[StreetTypeCode] CHECK CONSTRAINT [FK_StreetTypeCode_StreetType]
GO




SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[UnitType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[UnitType](
    [UnitTypeId] [int] IDENTITY(1,1) NOT NULL,
    [Code] [char](4) NOT NULL,
    [Description] [varchar](256) NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_UnitType] PRIMARY KEY CLUSTERED 
(
    [UnitTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'UnitTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a UnitType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'UnitTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO



SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[UnitTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[UnitTypeCode](
    [UnitTypeId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_UnitTypeCode] PRIMARY KEY CLUSTERED 
(
    [UnitTypeId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'UnitTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UnitType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'UnitTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'UnitTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'UnitTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_UnitTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode] CHECK CONSTRAINT [FK_UnitTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_UnitType]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_UnitTypeCode_UnitType] FOREIGN KEY([UnitTypeId])
REFERENCES [hips].[UnitType] ([UnitTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_UnitTypeCode_UnitType]') AND parent_object_id = OBJECT_ID(N'[hips].[UnitTypeCode]'))
ALTER TABLE [hips].[UnitTypeCode] CHECK CONSTRAINT [FK_UnitTypeCode_UnitType]
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetSuffixType]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetSuffixType](
    [StreetSuffixTypeId] [int] IDENTITY(1,1) NOT NULL,
    [Code] [char](4) NOT NULL,
    [Description] [varchar](256) NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetSuffixType] PRIMARY KEY CLUSTERED 
(
    [StreetSuffixTypeId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'StreetSuffixTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies a StreetSuffixType.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'StreetSuffixTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'Code'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ABS SACC (4 digits)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'Code'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description from ABS SACC' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixType', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixType', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[StreetSuffixTypeCode](
    [StreetSuffixTypeId] [int] NOT NULL,
    [CodeSystemId] [int] NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_StreetSuffixTypeCode] PRIMARY KEY CLUSTERED 
(
    [StreetSuffixTypeId] ASC,
    [CodeSystemId] ASC  
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'StreetSuffixTypeId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'StreetSuffixType' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'StreetSuffixTypeId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'CodeSystemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Type of identifier' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'CodeSystemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was created' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that created the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and Time the record was modified' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'StreetSuffixTypeCode', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User that modified the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'StreetSuffixTypeCode', @level2type=N'COLUMN',@level2name=N'UserModified'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem] FOREIGN KEY([CodeSystemId])
REFERENCES [hips].[CodeSystem] ([CodeSystemId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_CodeSystem]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode] CHECK CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_StreetSuffixType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode]  WITH CHECK ADD  CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType] FOREIGN KEY([StreetSuffixTypeId])
REFERENCES [hips].[StreetSuffixType] ([StreetSuffixTypeId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_StreetSuffixTypeCode_StreetSuffixType]') AND parent_object_id = OBJECT_ID(N'[hips].[StreetSuffixTypeCode]'))
ALTER TABLE [hips].[StreetSuffixTypeCode] CHECK CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType]
GO


--HPIIStatus
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HpiiStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HpiiStatus](
    [HpiiStatusId] [int] NOT NULL,
    [Description] [varchar](50) NOT NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HpiiStatus] PRIMARY KEY CLUSTERED 
(
    [HpiiStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiStatus', N'COLUMN',N'HpiiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the IHI status.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiStatus', @level2type=N'COLUMN',@level2name=N'HpiiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiStatus', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. Active, Undefined, Retired or Deactivated)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiStatus', @level2type=N'COLUMN',@level2name=N'Description'
GO


--HPIILookupAudit
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[HpiiLookupAudit](
    [HpiiLookupAuditId] [int] IDENTITY(1,1) NOT NULL,
    [HpiiNumber] [varchar](50) NULL,
    [HpiiStatusId] [int] NULL,
    [RegistrationId] [varchar](20) NULL,
    [FamilyName] [varchar](40) NOT NULL,
    [GivenNames] [varchar](500) NULL,
    [DateOfBirth] [datetime] NULL,
    [SexId] [int] NULL,
    [AustralianStateId] [int] NULL,
    [Postcode] [varchar](4) NULL,
    [CountryId] [int] NULL,
    [BatchItemId] [int] NULL,
    [BatchId] [int] NULL,
    [Message] [varchar](200) NULL,
    [OperatorHpiI] [varchar](16) NULL,
    [HpiO] [varchar](16) NOT NULL,
    [Operator] [varchar](100) NOT NULL,
    [IdentifierType] [varchar](40) NULL,
    [IdentifierValue]  [varchar](128) NULL,
    [HiWebServiceName] [varchar](40) NOT NULL,
    [HiWebServiceVersion] [varchar](10) NOT NULL,
    [ServiceMessageRequestID] [varchar](50),
    [ServiceMessageResponseID] [varchar](50),
    [Request] [xml] NULL,
    [Response] [xml] NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_HpiiLookupAudit] PRIMARY KEY CLUSTERED 
(
    [HpiiLookupAuditId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiiNumber'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII Number of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiiNumber'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiiStatusId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII Status of the returned HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiiStatusId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'RegistrationId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Registration Number of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'RegistrationId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'FamilyName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Family Name of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'FamilyName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'GivenNames'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Given Name of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'GivenNames'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateOfBirth'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of birth of the provider used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateOfBirth'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'SexId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Gender Identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'SexId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'AustralianStateId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Australian State Identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'AustralianStateId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Postcode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Postcode used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Postcode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'CountryId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Country identifier used in the Search for an HPII' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'CountryId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'BatchItemId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Singular identifier of a request within a batch ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'BatchItemId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'BatchId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Batch Identifier for the grouped batch request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'BatchId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Message'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Error or Warning Messages returned from the Hi Service ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Message'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'OperatorHpiI'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPII of the individual making the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'OperatorHpiI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HpiO'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPIO of the organisation making the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HpiO'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Operator'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Authorised operator that performed the request' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Operator'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'IdentifierType'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Local Identifier Type of associated local record identifiers' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'IdentifierType'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'IdentifierValue'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Local Identifier Value of associated local record identifiers' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'IdentifierValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HiWebServiceName'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Name of the HI Web Service called ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HiWebServiceName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'HiWebServiceVersion'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Version of the HI Web Service called ' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'HiWebServiceVersion'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'ServiceMessageRequestID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Message Request ID for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'ServiceMessageRequestID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'ServiceMessageResponseID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Message Response ID for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'ServiceMessageResponseID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Request'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Request XML for the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Request'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'Response'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Response XML from the Hi Service' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'Response'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date that this patient record was inserted into the table' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'UserCreated'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User account that inserted the record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserCreated'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'DateModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time that this record was last modified (or as inserted)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'DateModified'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'HpiiLookupAudit', N'COLUMN',N'UserModified'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The account of the user that last modified (or inserted) this record' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'HpiiLookupAudit', @level2type=N'COLUMN',@level2name=N'UserModified'
GO


IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Sex] FOREIGN KEY([SexId])
REFERENCES [hips].[Sex] ([SexId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Sex]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Sex]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Country] FOREIGN KEY([CountryId])
REFERENCES [hips].[Country] ([CountryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Country]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Country]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_State]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_State] FOREIGN KEY([AustralianStateId])
REFERENCES [hips].[State] ([StateId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_State]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_State]
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Status]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit]  WITH CHECK ADD  CONSTRAINT [FK_HpiiLookupAudit_Status] FOREIGN KEY([HpiiStatusId])
REFERENCES [hips].[HpiiStatus] ([HpiiStatusId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_HpiiLookupAudit_Status]') AND parent_object_id = OBJECT_ID(N'[hips].[HpiiLookupAudit]'))
ALTER TABLE [hips].[HpiiLookupAudit] CHECK CONSTRAINT [FK_HpiiLookupAudit_Status]
GO


GO
PRINT N'Altering extended properties for Hospital'
GO
EXEC sp_updateextendedproperty N'MS_Description', N'Name of the authorised employee for actions triggered by automatic processes, such as IHI/HPII searching and PCEHR advertised checking.', 'SCHEMA', N'hips', 'TABLE', N'Hospital', 'COLUMN', N'AuthorisedEmployeeName'
GO
EXEC sp_updateextendedproperty N'MS_Description', N'Identifier of the authorised employee for actions triggered by automatic processes, such as IHI/HPII searching and PCEHR advertised checking.', 'SCHEMA', N'hips', 'TABLE', N'Hospital', 'COLUMN', N'AuthorisedEmployeeUserId'
GO

--Add in new reference data for HPII

SET IDENTITY_INSERT [hips].[CodeSystem] ON
INSERT INTO [hips].[CodeSystem] ([CodeSystemId], [Code], [Description], [Oid], [Version], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (106, 'HI_ReferenceCodes', 'HI Reference Code', NULL, NULL, '2012-11-10 12:00:00.000', 'HIPS', '2012-11-10 12:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[CodeSystem] OFF


PRINT(N'Drop constraints from [hips].[CountryCode]')
GO
ALTER TABLE [hips].[CountryCode] DROP CONSTRAINT [FK_CountryCode_CodeSystem]
ALTER TABLE [hips].[CountryCode] DROP CONSTRAINT [FK_CountryCode_Country]

PRINT(N'Add 245 rows to [hips].[CountryCode]')
GO
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (71, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (72, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (73, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (74, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (76, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (77, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (78, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (79, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (81, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (82, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (83, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (84, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (85, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (86, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (87, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (89, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (90, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (91, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (92, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (93, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (94, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (95, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (96, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (97, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (98, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (100, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (102, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (103, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (104, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (105, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (106, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (107, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (108, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (111, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (112, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (113, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (114, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (115, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (116, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (119, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (121, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (122, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (123, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (124, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (125, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (126, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (127, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (128, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (129, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (131, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (132, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (133, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (134, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (135, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (136, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (137, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (141, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (142, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (143, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (144, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (145, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (146, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (147, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (148, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (150, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (151, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (152, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (153, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (154, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (155, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (156, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (157, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (158, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (159, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (160, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (165, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (166, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (167, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (168, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (169, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (170, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (171, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (172, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (173, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (174, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (177, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (178, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (179, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (180, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (181, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (182, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (183, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (185, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (187, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (188, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (189, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (190, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (191, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (192, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (193, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (194, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (195, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (196, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (197, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (198, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (199, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (200, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (201, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (204, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (205, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (206, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (207, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (208, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (210, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (211, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (212, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (213, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (214, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (215, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (218, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (219, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (220, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (221, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (222, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (224, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (225, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (226, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (229, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (230, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (231, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (232, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (233, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (234, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (235, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (237, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (238, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (239, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (240, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (241, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (242, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (243, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (244, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (245, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (248, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (249, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (250, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (251, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (253, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (254, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (255, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (256, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (257, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (258, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (259, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (260, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (261, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (262, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (263, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (264, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (265, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (266, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (267, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (269, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (270, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (271, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (272, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (273, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (274, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (275, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (276, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (278, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (279, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (280, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (281, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (282, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (283, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (284, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (285, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (286, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (287, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (288, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (289, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (290, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (291, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (292, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (293, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (294, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (295, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (296, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (297, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (298, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (299, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (300, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (301, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (306, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (307, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (308, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (309, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (310, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (311, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (312, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (313, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (314, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (315, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (316, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (317, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (318, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (319, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (320, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (321, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (322, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (323, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (324, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (325, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (326, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (327, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (328, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (329, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (331, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (332, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (333, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (334, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (335, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (336, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (337, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (338, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (339, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (340, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (341, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (342, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (343, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (344, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (345, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (346, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (347, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (348, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (349, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (350, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (351, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (352, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (353, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (354, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (355, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (356, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[CountryCode] ([CountryId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (357, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[CountryCode]')
GO
ALTER TABLE [hips].[CountryCode] ADD CONSTRAINT [FK_CountryCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[CountryCode] ADD CONSTRAINT [FK_CountryCode_Country] FOREIGN KEY ([CountryId]) REFERENCES [hips].[Country] ([CountryId])
GO


PRINT(N'Drop constraints from [hips].[StateCode]')
GO
ALTER TABLE [hips].[StateCode] DROP CONSTRAINT [FK_StateCode_CodeSystem]
ALTER TABLE [hips].[StateCode] DROP CONSTRAINT [FK_StateCode_State]

PRINT(N'Add 8 rows to [hips].[StateCode]')
GO
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StateCode] ([StateId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[StateCode]')
GO
ALTER TABLE [hips].[StateCode] ADD CONSTRAINT [FK_StateCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[StateCode] WITH NOCHECK ADD CONSTRAINT [FK_StateCode_State] FOREIGN KEY ([StateId]) REFERENCES [hips].[State] ([StateId])
GO


PRINT(N'Drop constraints from [hips].[SexCode]')
GO
ALTER TABLE [hips].[SexCode] DROP CONSTRAINT [FK_SexCode_CodeSystem]
ALTER TABLE [hips].[SexCode] DROP CONSTRAINT [FK_SexCode_Sex]

PRINT(N'Add 4 rows to [hips].[SexCode]')
GO
INSERT INTO [hips].[SexCode] ([SexId], [CodeSystemId], [CodeOverride], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (-1, 106, NULL, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[SexCode] ([SexId], [CodeSystemId], [CodeOverride], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, NULL, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[SexCode] ([SexId], [CodeSystemId], [CodeOverride], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, NULL, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[SexCode] ([SexId], [CodeSystemId], [CodeOverride], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, NULL, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[SexCode]')
GO
ALTER TABLE [hips].[SexCode] WITH NOCHECK ADD CONSTRAINT [FK_SexCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[SexCode] WITH NOCHECK ADD CONSTRAINT [FK_SexCode_Sex] FOREIGN KEY ([SexId]) REFERENCES [hips].[Sex] ([SexId])
GO


PRINT(N'Drop constraint FK_StreetTypeCode_StreetType from [hips].[StreetTypeCode]')
GO
ALTER TABLE [hips].[StreetTypeCode] DROP CONSTRAINT [FK_StreetTypeCode_StreetType]

PRINT(N'Add 204 rows to [hips].[StreetType]')
GO
SET IDENTITY_INSERT [hips].[StreetType] ON
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'ACCS', 'ACCESS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'ALLY', 'ALLEY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'ALWY', 'ALLEYWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'AMBL', 'AMBLE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'ANCG', 'ANCHORAGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'APP ', 'APPROACH', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'ARC ', 'ARCADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'ART ', 'ARTERY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 'AVE ', 'AVENUE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'BASN', 'BASIN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'BCH ', 'BEACH', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'BEND', 'BEND', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 'BLK ', 'BLOCK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 'BWLK', 'BOARDWALK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 'BVD ', 'BOULEVARD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (16, 'BRCE', 'BRACE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (17, 'BRAE', 'BRAE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (18, 'BRK ', 'BREAK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (19, 'BDGE', 'BRIDGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 'BDWY', 'BROADWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 'BROW', 'BROW', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, 'BYPA', 'BYPASS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, 'BYWY', 'BYWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, 'CAUS', 'CAUSEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, 'CTR ', 'CENTRE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, 'CNWY', 'CENTREWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, 'CH  ', 'CHASE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (28, 'CIR ', 'CIRCLE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (29, 'CLT ', 'CIRCLET', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (30, 'CCT ', 'CIRCUIT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (31, 'CRCS', 'CIRCUS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (32, 'CL  ', 'CLOSE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (33, 'CLDE', 'COLONNADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (34, 'CMMN', 'COMMON', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (35, 'CON ', 'CONCOURSE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (36, 'CPS ', 'COPSE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (37, 'CNR ', 'CORNER', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (38, 'CSO ', 'CORSO', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (39, 'CT  ', 'COURT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (40, 'CTYD', 'COURTYARD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (41, 'COVE', 'COVE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (42, 'CRES', 'CRESCENT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (43, 'CRST', 'CREST', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (44, 'CRSS', 'CROSS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (45, 'CRSG', 'CROSSING', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (46, 'CRD ', 'CROSSROAD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (47, 'COWY', 'CROSSWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (48, 'CUWY', 'CRUISEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (49, 'CDS ', 'CUL-DE-SAC', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (50, 'CTTG', 'CUTTING', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (51, 'DALE', 'DALE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (52, 'DELL', 'DELL', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (53, 'DEVN', 'DEVIATION', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (54, 'DIP ', 'DIP', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (55, 'DSTR', 'DISTRIBUTOR', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (56, 'DR  ', 'DRIVE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (57, 'DRWY', 'DRIVEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (58, 'EDGE', 'EDGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (59, 'ELB ', 'ELBOW', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (60, 'END ', 'END', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (61, 'ENT ', 'ENTRANCE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (62, 'ESP ', 'ESPLANADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (63, 'EST ', 'ESTATE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (64, 'EXP ', 'EXPRESSWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (65, 'EXTN', 'EXTENSION', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (66, 'FAWY', 'FAIRWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (67, 'FTRK', 'FIRETRACK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (68, 'FITR', 'FIRETRAIL', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (69, 'FLAT', 'FLAT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (70, 'FOLW', 'FOLLOW', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (71, 'FTWY', 'FOOTWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (72, 'FSHR', 'FORESHORE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (73, 'FORM', 'FORMATION', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (74, 'FWY ', 'FREEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (75, 'FRNT', 'FRONT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (76, 'FRTG', 'FRONTAGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (77, 'GAP ', 'GAP', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (78, 'GDN ', 'GARDEN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (79, 'GDNS', 'GARDENS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (80, 'GTE ', 'GATE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (81, 'GTES', 'GATES', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (82, 'GLD ', 'GLADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (83, 'GLEN', 'GLEN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (84, 'GRA ', 'GRANGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (85, 'GRN ', 'GREEN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (86, 'GRND', 'GROUND', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (87, 'GR  ', 'GROVE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (88, 'GLY ', 'GULLY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (89, 'HTS ', 'HEIGHTS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (90, 'HRD ', 'HIGHROAD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (91, 'HWY ', 'HIGHWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (92, 'HILL', 'HILL', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (93, 'INTG', 'INTERCHANGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (94, 'INTN', 'INTERSECTION', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (95, 'JNC ', 'JUNCTION', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (96, 'KEY ', 'KEY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (97, 'LDG ', 'LANDING', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (98, 'LANE', 'LANE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (99, 'LNWY', 'LANEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (100, 'LEES', 'LEES', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (101, 'LINE', 'LINE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (102, 'LINK', 'LINK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (103, 'LT  ', 'LITTLE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (104, 'LKT ', 'LOOKOUT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (105, 'LOOP', 'LOOP', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (106, 'LW  ', 'LOWER', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (107, 'MALL', 'MALL', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (108, 'MNDR', 'MEANDER', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (109, 'MEW ', 'MEW', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (110, 'MEWS', 'MEWS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (111, 'MWY ', 'MOTORWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (112, 'MT  ', 'MOUNT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (113, 'NOOK', 'NOOK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (114, 'OTLK', 'OUTLOOK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (115, 'PDE ', 'PARADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (116, 'PARK', 'PARK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (117, 'PKLD', 'PARKLANDS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (118, 'PKWY', 'PARKWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (119, 'PART', 'PART', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (120, 'PASS', 'PASS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (121, 'PATH', 'PATH', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (122, 'PHWY', 'PATHWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (123, 'PIAZ', 'PIAZZA', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (124, 'PL  ', 'PLACE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (125, 'PLAT', 'PLATEAU', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (126, 'PLZA', 'PLAZA', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (127, 'PKT ', 'POCKET', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (128, 'PNT ', 'POINT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (129, 'PORT', 'PORT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (130, 'PROM', 'PROMENADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (131, 'QUAD', 'QUAD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (132, 'QDGL', 'QUADRANGLE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (133, 'QDRT', 'QUADRANT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (134, 'QY  ', 'QUAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (135, 'QYS ', 'QUAYS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (136, 'RMBL', 'RAMBLE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (137, 'RAMP', 'RAMP', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (138, 'RNGE', 'RANGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (139, 'RCH ', 'REACH', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (140, 'RES ', 'RESERVE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (141, 'REST', 'REST', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (142, 'RTT ', 'RETREAT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (143, 'RIDE', 'RIDE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (144, 'RDGE', 'RIDGE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (145, 'RGWY', 'RIDGEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (146, 'ROWY', 'RIGHTOFWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (147, 'RING', 'RING', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (148, 'RISE', 'RISE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (149, 'RVR ', 'RIVER', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (150, 'RVWY', 'RIVERWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (151, 'RVRA', 'RIVIERA', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (152, 'RD  ', 'ROAD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (153, 'RDS ', 'ROADS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (154, 'RDSD', 'ROADSIDE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (155, 'RDWY', 'ROADWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (156, 'RNDE', 'RONDE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (157, 'RSBL', 'ROSEBOWL', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (158, 'RTY ', 'ROTARY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (159, 'RND ', 'ROUND', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (160, 'RTE ', 'ROUTE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (161, 'ROW ', 'ROW', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (162, 'RUE ', 'RUE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (163, 'RUN ', 'RUN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (164, 'SWY ', 'SERVICEWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (165, 'SHUN', 'SHUNT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (166, 'SDNG', 'SIDING', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (167, 'SLPE', 'SLOPE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (168, 'SND ', 'SOUND', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (169, 'SPUR', 'SPUR', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (170, 'SQ  ', 'SQUARE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (171, 'STRS', 'STAIRS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (172, 'SHWY', 'STATEHIGHWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (173, 'STPS', 'STEPS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (174, 'STRA', 'STRAND', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (175, 'ST  ', 'STREET', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (176, 'STRP', 'STRIP', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (177, 'SBWY', 'SUBWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (178, 'TARN', 'TARN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (179, 'TCE ', 'TERRACE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (180, 'THOR', 'THOROUGHFARE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (181, 'TLWY', 'TOLLWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (182, 'TOP ', 'TOP', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (183, 'TOR ', 'TOR', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (184, 'TWRS', 'TOWERS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (185, 'TRK ', 'TRACK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (186, 'TRL ', 'TRAIL', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (187, 'TRLR', 'TRAILER', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (188, 'TRI ', 'TRIANGLE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (189, 'TKWY', 'TRUNKWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (190, 'TURN', 'TURN', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (191, 'UPAS', 'UNDERPASS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (192, 'UPR ', 'UPPER', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (193, 'VALE', 'VALE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (194, 'VDCT', 'VIADUCT', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (195, 'VIEW', 'VIEW', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (196, 'VLLS', 'VILLAS', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (197, 'VSTA', 'VISTA', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (198, 'WADE', 'WADE', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (199, 'WALK', 'WALK', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (200, 'WKWY', 'WALKWAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (201, 'WAY ', 'WAY', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (202, 'WHRF', 'WHARF', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (203, 'WYND', 'WYND', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetType] ([StreetTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (204, 'YARD', 'YARD', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[StreetType] OFF

PRINT(N'Add constraint FK_StreetTypeCode_StreetType to [hips].[StreetTypeCode]')
GO
ALTER TABLE [hips].[StreetTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_StreetTypeCode_StreetType] FOREIGN KEY ([StreetTypeId]) REFERENCES [hips].[StreetType] ([StreetTypeId])

GO


PRINT(N'Drop constraints from [hips].[StreetTypeCode]')
GO
ALTER TABLE [hips].[StreetTypeCode] DROP CONSTRAINT [FK_StreetTypeCode_CodeSystem]
ALTER TABLE [hips].[StreetTypeCode] DROP CONSTRAINT [FK_StreetTypeCode_StreetType]

PRINT(N'Add 204 rows to [hips].[StreetTypeCode]')
GO
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (16, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (17, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (18, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (19, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (28, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (29, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (30, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (31, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (32, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (33, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (34, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (35, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (36, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (37, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (38, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (39, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (40, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (41, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (42, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (43, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (44, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (45, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (46, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (47, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (48, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (49, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (50, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (51, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (52, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (53, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (54, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (55, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (56, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (57, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (58, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (59, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (60, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (61, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (62, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (63, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (64, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (65, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (66, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (67, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (68, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (69, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (70, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (71, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (72, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (73, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (74, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (75, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (76, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (77, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (78, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (79, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (80, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (81, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (82, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (83, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (84, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (85, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (86, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (87, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (88, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (89, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (90, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (91, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (92, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (93, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (94, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (95, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (96, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (97, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (98, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (99, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (100, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (101, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (102, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (103, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (104, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (105, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (106, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (107, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (108, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (109, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (110, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (111, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (112, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (113, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (114, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (115, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (116, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (117, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (118, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (119, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (120, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (121, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (122, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (123, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (124, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (125, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (126, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (127, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (128, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (129, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (130, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (131, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (132, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (133, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (134, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (135, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (136, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (137, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (138, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (139, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (140, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (141, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (142, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (143, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (144, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (145, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (146, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (147, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (148, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (149, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (150, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (151, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (152, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (153, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (154, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (155, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (156, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (157, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (158, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (159, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (160, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (161, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (162, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (163, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (164, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (165, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (166, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (167, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (168, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (169, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (170, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (171, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (172, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (173, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (174, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (175, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (176, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (177, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (178, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (179, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (180, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (181, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (182, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (183, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (184, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (185, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (186, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (187, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (188, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (189, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (190, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (191, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (192, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (193, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (194, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (195, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (196, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (197, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (198, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (199, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (200, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (201, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (202, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (203, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetTypeCode] ([StreetTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (204, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[StreetTypeCode]')
GO
ALTER TABLE [hips].[StreetTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_StreetTypeCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[StreetTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_StreetTypeCode_StreetType] FOREIGN KEY ([StreetTypeId]) REFERENCES [hips].[StreetType] ([StreetTypeId])

GO

PRINT(N'Drop constraint FK_UnitTypeCode_UnitType from [hips].[UnitTypeCode]')
GO
ALTER TABLE [hips].[UnitTypeCode] DROP CONSTRAINT [FK_UnitTypeCode_UnitType]

PRINT(N'Add 48 rows to [hips].[UnitType]')
GO
SET IDENTITY_INSERT [hips].[UnitType] ON
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'ANT ', 'Antenna', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'APT ', 'Apartment', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'ATM ', 'Automated Teller Machine', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'BBQ ', 'Barbeque', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'BTSD', 'Boatshed', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'BLDG', 'Building', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'BNGW', 'Bungalow', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'CAGE', 'Cage', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 'CARP', 'Carpark', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'CARS', 'Carspace', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'CLUB', 'Club', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'COOL', 'Coolroom', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 'CTGE', 'Cottage', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 'DUP ', 'Duplex', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 'FY  ', 'Factory', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (16, 'F   ', 'Flat', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (17, 'GRGE', 'Garage', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (18, 'HALL', 'Hall', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (19, 'HSE ', 'House', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 'KSK ', 'Kiosk', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 'LSE ', 'Lease', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, 'LBBY', 'Lobby', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, 'LOFT', 'Loft', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, 'LOT ', 'Lot', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, 'MSNT', 'Maisonette', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, 'MB  ', 'Marine berth', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, ' OFF', 'Office', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (28, 'PTHS', 'Penthouse', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (29, 'RESV', 'Reserve', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (30, 'RM  ', 'Room', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (31, 'SHED', 'Shed', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (32, 'SHOP', 'Shop', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (33, 'SIGN', 'Sign', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (34, 'SITE', 'Site', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (35, 'SL  ', 'Stall', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (36, 'STOR', 'Store', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (37, 'STR ', 'Strata Unit', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (38, 'STU ', 'Studio', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (39, 'SUBS', 'Substation', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (40, 'SE  ', 'Suite', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (41, 'TNCY', 'Tenancy', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (42, 'TWR ', 'Tower', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (43, 'TNHS', 'Townhouse', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (44, 'U   ', 'Unit', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (45, 'VLLA', 'Villa', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (46, 'WARD', 'Ward', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (47, 'WE  ', 'Warehouse', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitType] ([UnitTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (48, 'WKSH', 'Workshop', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[UnitType] OFF

PRINT(N'Add constraint FK_UnitTypeCode_UnitType to [hips].[UnitTypeCode]')
GO
ALTER TABLE [hips].[UnitTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_UnitTypeCode_UnitType] FOREIGN KEY ([UnitTypeId]) REFERENCES [hips].[UnitType] ([UnitTypeId])
GO

PRINT(N'Drop constraints from [hips].[UnitTypeCode]')
GO
ALTER TABLE [hips].[UnitTypeCode] DROP CONSTRAINT [FK_UnitTypeCode_CodeSystem]
ALTER TABLE [hips].[UnitTypeCode] DROP CONSTRAINT [FK_UnitTypeCode_UnitType]

PRINT(N'Add 48 rows to [hips].[UnitTypeCode]')
GO
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (16, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (17, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (18, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (19, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (28, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (29, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (30, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (31, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (32, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (33, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (34, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (35, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (36, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (37, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (38, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (39, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (40, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (41, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (42, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (43, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (44, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (45, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (46, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (47, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[UnitTypeCode] ([UnitTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (48, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[UnitTypeCode]')
GO
ALTER TABLE [hips].[UnitTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_UnitTypeCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[UnitTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_UnitTypeCode_UnitType] FOREIGN KEY ([UnitTypeId]) REFERENCES [hips].[UnitType] ([UnitTypeId])

GO

PRINT(N'Drop constraint FK_LevelTypeCode_LevelType from [hips].[LevelTypeCode]')
GO
ALTER TABLE [hips].[LevelTypeCode] DROP CONSTRAINT [FK_LevelTypeCode_LevelType]

PRINT(N'Add 15 rows to [hips].[LevelType]')
GO
SET IDENTITY_INSERT [hips].[LevelType] ON
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'B   ', 'Basement', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'FL  ', 'Floor', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'G   ', 'Ground', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'L   ', 'Level', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'LG  ', 'Lower Ground', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'M   ', 'Mezzanine', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'OD  ', 'Observation Deck', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'P   ', 'Parking', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 'PTHS', 'Penthouse', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'PLF ', 'Platform', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'PLZA', 'Plaza', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'PDM ', 'Podium', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 'RT  ', 'Rooftop', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 'SB  ', 'Sub Basement', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelType] ([LevelTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 'UG  ', 'Upper Ground', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[LevelType] OFF

PRINT(N'Add constraint FK_LevelTypeCode_LevelType to [hips].[LevelTypeCode]')
GO
ALTER TABLE [hips].[LevelTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_LevelTypeCode_LevelType] FOREIGN KEY ([LevelTypeId]) REFERENCES [hips].[LevelType] ([LevelTypeId])
GO

PRINT(N'Drop constraints from [hips].[LevelTypeCode]')
GO
ALTER TABLE [hips].[LevelTypeCode] DROP CONSTRAINT [FK_LevelTypeCode_CodeSystem]
ALTER TABLE [hips].[LevelTypeCode] DROP CONSTRAINT [FK_LevelTypeCode_LevelType]

PRINT(N'Add 15 rows to [hips].[LevelTypeCode]')
GO
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[LevelTypeCode] ([LevelTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[LevelTypeCode]')
GO
ALTER TABLE [hips].[LevelTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_LevelTypeCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[LevelTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_LevelTypeCode_LevelType] FOREIGN KEY ([LevelTypeId]) REFERENCES [hips].[LevelType] ([LevelTypeId])
GO

PRINT(N'Drop constraint FK_PostalDeliveryTypeCode_PostalDeliveryType from [hips].[PostalDeliveryTypeCode]')
GO
ALTER TABLE [hips].[PostalDeliveryTypeCode] DROP CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType]

PRINT(N'Add 12 rows to [hips].[PostalDeliveryType]')
GO
SET IDENTITY_INSERT [hips].[PostalDeliveryType] ON
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'CarePO', 'Care-of Post Office (also known as Poste Restante)', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'CMA', 'Community Mail Agent', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'CMB', 'Community Mail Bag', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'GPOBox', 'General Post Office Box', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'LockedBag', 'Locked Mail Bag Service', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'MS', 'Mail Service', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'POBox', 'Post Office Box', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'POR', 'Poste Restante (also known as Care-of Post Office)', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 'PrivateBag', 'Private Mail Bag Service', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'RSD', 'Roadside Delivery', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'RMB', 'Roadside Mail Box/Bag', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryType] ([PostalDeliveryTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'RMS', 'Roadside Mail Service', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[PostalDeliveryType] OFF

PRINT(N'Add constraint FK_PostalDeliveryTypeCode_PostalDeliveryType to [hips].[PostalDeliveryTypeCode]')
GO
ALTER TABLE [hips].[PostalDeliveryTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType] FOREIGN KEY ([PostalDeliveryTypeId]) REFERENCES [hips].[PostalDeliveryType] ([PostalDeliveryTypeId])
GO


PRINT(N'Drop constraints from [hips].[PostalDeliveryTypeCode]')
GO
ALTER TABLE [hips].[PostalDeliveryTypeCode] DROP CONSTRAINT [FK_PostalDeliveryTypeCode_CodeSystem]
ALTER TABLE [hips].[PostalDeliveryTypeCode] DROP CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType]

PRINT(N'Add 12 rows to [hips].[PostalDeliveryTypeCode]')
GO
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[PostalDeliveryTypeCode] ([PostalDeliveryTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[PostalDeliveryTypeCode]')
GO
ALTER TABLE [hips].[PostalDeliveryTypeCode] ADD CONSTRAINT [FK_PostalDeliveryTypeCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[PostalDeliveryTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_PostalDeliveryTypeCode_PostalDeliveryType] FOREIGN KEY ([PostalDeliveryTypeId]) REFERENCES [hips].[PostalDeliveryType] ([PostalDeliveryTypeId])
GO

PRINT(N'Drop constraint FK_StreetSuffixTypeCode_StreetSuffixType from [hips].[StreetSuffixTypeCode]')
GO
ALTER TABLE [hips].[StreetSuffixTypeCode] DROP CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType]


PRINT(N'Add 12 rows to [hips].[StreetSuffixType]')
GO
SET IDENTITY_INSERT [hips].[StreetSuffixType] ON
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'CN  ', 'Central', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'E   ', 'East', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'EX  ', 'Extension', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'LR  ', 'Lower', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'N   ', 'North', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'NE  ', 'North East', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'NW  ', 'North West', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'S   ', 'South', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 'SE  ', 'South East', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'SW  ', 'South West', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'UP  ', 'Upper', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixType] ([StreetSuffixTypeId], [Code], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'W   ', 'West', '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[StreetSuffixType] OFF

PRINT(N'Add constraint FK_StreetSuffixTypeCode_StreetSuffixType to [hips].[StreetSuffixTypeCode]')
GO
ALTER TABLE [hips].[StreetSuffixTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType] FOREIGN KEY ([StreetSuffixTypeId]) REFERENCES [hips].[StreetSuffixType] ([StreetSuffixTypeId])
GO

PRINT(N'Drop constraints from [hips].[StreetSuffixTypeCode]')
GO
ALTER TABLE [hips].[StreetSuffixTypeCode] DROP CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem]
ALTER TABLE [hips].[StreetSuffixTypeCode] DROP CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType]

PRINT(N'Add 12 rows to [hips].[StreetSuffixTypeCode]')
GO
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[StreetSuffixTypeCode] ([StreetSuffixTypeId], [CodeSystemId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 106, '2013-11-10 00:00:00.000', 'HIPS', '2013-11-10 00:00:00.000', 'HIPS')

PRINT(N'Add constraints to [hips].[StreetSuffixTypeCode]')
GO
ALTER TABLE [hips].[StreetSuffixTypeCode] ADD CONSTRAINT [FK_StreetSuffixTypeCode_CodeSystem] FOREIGN KEY ([CodeSystemId]) REFERENCES [hips].[CodeSystem] ([CodeSystemId])
ALTER TABLE [hips].[StreetSuffixTypeCode] WITH NOCHECK ADD CONSTRAINT [FK_StreetSuffixTypeCode_StreetSuffixType] FOREIGN KEY ([StreetSuffixTypeId]) REFERENCES [hips].[StreetSuffixType] ([StreetSuffixTypeId])
GO



PRINT(N'Add 4 rows to [hips].[HpiiStatus]')
GO
IF NOT EXISTS (SELECT HpiiStatusId FROM hips.HpiiStatus WHERE HpiiStatusId = -1)
BEGIN
    INSERT hips.HpiiStatus (HpiiStatusId, Description, DateCreated, UserCreated, DateModified, UserModified)
    VALUES (-1, 'Undefined', GETDATE(), 'HIPS', GETDATE(), 'HIPS')
END
IF NOT EXISTS (SELECT HpiiStatusId FROM hips.HpiiStatus WHERE HpiiStatusId = 1)
BEGIN
    INSERT hips.HpiiStatus (HpiiStatusId, Description, DateCreated, UserCreated, DateModified, UserModified)
    VALUES (1, 'Active', GETDATE(), 'HIPS', GETDATE(), 'HIPS')
END
IF NOT EXISTS (SELECT HpiiStatusId FROM hips.HpiiStatus WHERE HpiiStatusId = 2)
BEGIN
    INSERT hips.HpiiStatus (HpiiStatusId, Description, DateCreated, UserCreated, DateModified, UserModified)
    VALUES (2, 'Deactivated', GETDATE(), 'HIPS', GETDATE(), 'HIPS')
END
IF NOT EXISTS (SELECT HpiiStatusId FROM hips.HpiiStatus WHERE HpiiStatusId = 3)
BEGIN
    INSERT hips.HpiiStatus (HpiiStatusId, Description, DateCreated, UserCreated, DateModified, UserModified)
    VALUES (3, 'Retired', GETDATE(), 'HIPS', GETDATE(), 'HIPS')
END



-- =============================================
-- Adds in new Log Message records
-- =============================================

-- New log message for error in the HealthProvdierOrganisation store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(138, 'Database error while calling HealthProviderOrganisationGetAll', 'HealthProviderOrganisationDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- Grouping for new log message 
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,138,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')


-- New log message for error in the HealthProvdierOrganisation store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(139, 'Database error while calling HealthProviderOrganisationGet by ID', 'HealthProviderOrganisationDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- Grouping for new log message 
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,139,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')




-- New log message for error in the StreetSuffixTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(140, 'Database error while calling StreetSuffixTypeCodeGet ', 'StreetSuffixTypeCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the StreetSuffixTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(141, 'Database error while calling StreetSuffixTypeCodeGet By ID', 'StreetSuffixTypeCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the StreetTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(142, 'Database error while calling StreetTypeCodeGet ', 'StreetTypeCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the StreetTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(143, 'Database error while calling StreetTypeCodeGet By ID', 'StreetTypeCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the UnitTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(144, 'Database error while calling UnitTypeCodeGet ', 'UnitTypeCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the UnitTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(145, 'Database error while calling UnitTypeCodeGet By ID', 'UnitTypeCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the LevelTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(146, 'Database error while calling LevelTypeCodeGet ', 'LevelTypeCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the LevelTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(147, 'Database error while calling LevelTypeCodeGet By ID', 'LevelTypeCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the PostalDeliveryTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(148, 'Database error while calling PostalDeliveryTypeCodeGet ', 'PostalDeliveryTypeCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the PostalDeliveryTypeCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(149, 'Database error while calling PostalDeliveryTypeCodeGet By ID', 'PostalDeliveryTypeCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the StateCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(150, 'Database error while calling StateCodeGet ', 'StateCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the StateCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(151, 'Database error while calling StateCodeGet By ID', 'StateCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the CountryCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(152, 'Database error while calling CountryCodeGet ', 'CountryCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the CountryCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(153, 'Database error while calling CountryCodeGet By ID', 'CountryCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the SexCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(154, 'Database error while calling SexCodeGet ', 'SexCodeDl', 'GetAll', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

-- New log message for error in the SexCodeGet store procedure
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [Class], [Method], [DateCreated], [UserCreated], [DateModified], [UserModified]) 
VALUES(155, 'Database error while calling SexCodeGet By ID', 'SexCodeDl', 'Get', '2013-10-30 12:00:00.000', 'HIPS', '2013-10-30 12:00:00.000', 'HIPS')

INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,140,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,141,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,142,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,143,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,144,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,145,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,146,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,147,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,148,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,149,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,150,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,151,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,152,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,153,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,154,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')
INSERT hips.MonitorTabMessage ([MonitorTabId], [LogMessageId], [DateCreated], [UserCreated], [DateModified], [UserModified])
VALUES (1,155,'2013-10-30 12:00:00.000','HIPS','2013-10-30 12:00:00.000','HIPS')


-- ========================================================
-- Upgrades DocumentFormat table contents from HIPS 4.0.4 to 4.1.0.
--
-- Inserts format codes that describe documents that HIPS 4.1.0 is now NOC tested to upload:
--   PCEHR R3 - Discharge Summary
--   PCEHR R4 - Discharge Summary
--   PCEHR R4 - Shared Health Summary
--   PCEHR R4 - Event Summary
--   PCEHR R4 - Specialist Letter
--   PCEHR R4 - PCEHR Prescription Record
--   PCEHR R4 - PCEHR Dispense Record
--
-- Deletes format codes that describe documents which HIPS has never been NOC tested to upload:
--   eReferral
--   Medicare/DVA Benefits Record
--   Pharmaceutical Benefits Report
--   Australian Childhood Immunisation Register
--   Australian Organ Donor Registry
--   Consumer Entered Notes
--   Consumer Entered Health Summary
--   Advance Care Directive Custodian Record 
--   PCEHR R2 Specialist Letter
--   PCEHR R2 Event Summary
--   PCEHR R2 Shared Health Summary
--
-- Updates description on existing format codes.
--   PCEHR R2 Discharge Summary
--   PCEHR R3 Discharge Summary
-- ========================================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16473.6'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16565.3'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.10'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.11'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.12'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.9'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16644.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16650.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16659.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16671.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16681.2'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16685.2'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16696.2'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.10'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.11'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.12'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.9'

UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 1A' WHERE Code='1.2.36.1.2001.1006.1.20000.12'
UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 1B' WHERE Code='1.2.36.1.2001.1006.1.20000.9'
UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 2' WHERE Code='1.2.36.1.2001.1006.1.20000.10'
UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 3A' WHERE Code='1.2.36.1.2001.1006.1.20000.11'
UPDATE hips.DocumentFormat SET Description='PCEHR R3 - Discharge Summary - Conformance 2' WHERE Code='1.2.36.1.2001.1006.1.20000.15'
UPDATE hips.DocumentFormat SET Description='PCEHR R3 - Discharge Summary - Conformance 3A' WHERE Code='1.2.36.1.2001.1006.1.20000.16'

INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.10','PCEHR R4 - Event Summary - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.11','PCEHR R4 - Event Summary - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.8','PCEHR R4 - Event Summary - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.9','PCEHR R4 - Event Summary - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.4','PCEHR R4 - Shared Health Summary - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.5','PCEHR R4 - Shared Health Summary - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.6','PCEHR R4 - Shared Health Summary - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.7','PCEHR R4 - Shared Health Summary - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.13','PCEHR R4 - Specialist Letter - Conformance 1A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.14','PCEHR R4 - Specialist Letter - Conformance 1B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.15','PCEHR R4 - Specialist Letter - Conformance 2 - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.16','PCEHR R4 - Specialist Letter - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.17','PCEHR R4 - Specialist Letter - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.18','PCEHR R4 - Specialist Letter - Conformance 1A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.19','PCEHR R4 - Specialist Letter - Conformance 1B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.20','PCEHR R4 - Specialist Letter - Conformance 2 - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.21','PCEHR R4 - Specialist Letter - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.22','PCEHR R4 - Specialist Letter - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.170.2','PCEHR R4 - PCEHR Prescription Record - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.170.3','PCEHR R4 - PCEHR Prescription Record - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.171.2','PCEHR R4 - PCEHR Dispense Record - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.171.3','PCEHR R4 - PCEHR Dispense Record - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.13','PCEHR R3 - Discharge Summary - Conformance 1A',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.14','PCEHR R3 - Discharge Summary - Conformance 1B',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.17','PCEHR R3 - Discharge Summary - Conformance 3B',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.18','PCEHR R4 - Discharge Summary - Conformance 1A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.19','PCEHR R4 - Discharge Summary - Conformance 1B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.20','PCEHR R4 - Discharge Summary - Conformance 2 - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.21','PCEHR R4 - Discharge Summary - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.22','PCEHR R4 - Discharge Summary - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.23','PCEHR R4 - Discharge Summary - Conformance 1A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.24','PCEHR R4 - Discharge Summary - Conformance 1B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.25','PCEHR R4 - Discharge Summary - Conformance 2 - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.26','PCEHR R4 - Discharge Summary - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.27','PCEHR R4 - Discharge Summary - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')

GO


IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

IF @@TRANCOUNT>0 BEGIN
PRINT 'The database update succeeded'
COMMIT TRANSACTION
END
ELSE PRINT 'The database update failed'
GO

