﻿-- ========================================================
-- Upgrades DocumentFormat table contents from HIPS 4.0.4 to 4.1.0.
--
-- Inserts format codes that describe documents that HIPS 4.1.0 is now NOC tested to upload:
--   PCEHR R3 - Discharge Summary
--   PCEHR R4 - Discharge Summary
--   PCEHR R4 - Shared Health Summary
--   PCEHR R4 - Event Summary
--   PCEHR R4 - Specialist Letter
--   PCEHR R4 - PCEHR Prescription Record
--   PCEHR R4 - PCEHR Dispense Record
--
-- Deletes format codes that describe documents which HIPS has never been NOC tested to upload:
--   eReferral
--   Medicare/DVA Benefits Record
--   Pharmaceutical Benefits Report
--   Australian Childhood Immunisation Register
--   Australian Organ Donor Registry
--   Consumer Entered Notes
--   Consumer Entered Health Summary
--   Advance Care Directive Custodian Record 
--   PCEHR R2 Specialist Letter
--   PCEHR R2 Event Summary
--   PCEHR R2 Shared Health Summary
--
-- Updates description on existing format codes.
--   PCEHR R2 Discharge Summary
--   PCEHR R3 Discharge Summary
-- ========================================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16473.6'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16565.3'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.10'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.11'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.12'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16615.9'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16644.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16650.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16659.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16671.5'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16681.2'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16685.2'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.16696.2'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.10'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.11'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.12'
DELETE hips.DocumentFormat WHERE Code='1.2.36.1.2001.1006.1.21000.9'

UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 1A' WHERE Code='1.2.36.1.2001.1006.1.20000.12'
UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 1B' WHERE Code='1.2.36.1.2001.1006.1.20000.9'
UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 2' WHERE Code='1.2.36.1.2001.1006.1.20000.10'
UPDATE hips.DocumentFormat SET Description='PCEHR R2 - Discharge Summary - Conformance 3A' WHERE Code='1.2.36.1.2001.1006.1.20000.11'
UPDATE hips.DocumentFormat SET Description='PCEHR R3 - Discharge Summary - Conformance 2' WHERE Code='1.2.36.1.2001.1006.1.20000.15'
UPDATE hips.DocumentFormat SET Description='PCEHR R3 - Discharge Summary - Conformance 3A' WHERE Code='1.2.36.1.2001.1006.1.20000.16'

INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.10','PCEHR R4 - Event Summary - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.11','PCEHR R4 - Event Summary - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.8','PCEHR R4 - Event Summary - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16473.9','PCEHR R4 - Event Summary - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.4','PCEHR R4 - Shared Health Summary - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.5','PCEHR R4 - Shared Health Summary - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.6','PCEHR R4 - Shared Health Summary - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16565.7','PCEHR R4 - Shared Health Summary - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.13','PCEHR R4 - Specialist Letter - Conformance 1A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.14','PCEHR R4 - Specialist Letter - Conformance 1B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.15','PCEHR R4 - Specialist Letter - Conformance 2 - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.16','PCEHR R4 - Specialist Letter - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.17','PCEHR R4 - Specialist Letter - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.18','PCEHR R4 - Specialist Letter - Conformance 1A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.19','PCEHR R4 - Specialist Letter - Conformance 1B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.20','PCEHR R4 - Specialist Letter - Conformance 2 - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.21','PCEHR R4 - Specialist Letter - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.16615.22','PCEHR R4 - Specialist Letter - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.170.2','PCEHR R4 - PCEHR Prescription Record - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.170.3','PCEHR R4 - PCEHR Prescription Record - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.171.2','PCEHR R4 - PCEHR Dispense Record - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.171.3','PCEHR R4 - PCEHR Dispense Record - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.13','PCEHR R3 - Discharge Summary - Conformance 1A',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.14','PCEHR R3 - Discharge Summary - Conformance 1B',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.17','PCEHR R3 - Discharge Summary - Conformance 3B',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.18','PCEHR R4 - Discharge Summary - Conformance 1A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.19','PCEHR R4 - Discharge Summary - Conformance 1B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.20','PCEHR R4 - Discharge Summary - Conformance 2 - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.21','PCEHR R4 - Discharge Summary - Conformance 3A - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.22','PCEHR R4 - Discharge Summary - Conformance 3B - HPI-I relaxed',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.23','PCEHR R4 - Discharge Summary - Conformance 1A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.24','PCEHR R4 - Discharge Summary - Conformance 1B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.25','PCEHR R4 - Discharge Summary - Conformance 2 - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.26','PCEHR R4 - Discharge Summary - Conformance 3A - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')
INSERT INTO [hips].[DocumentFormat] ([Code],[Description] ,[CodeSystemId] ,[DateCreated] ,[UserCreated] ,[DateModified] ,[UserModified]) 
VALUES ('1.2.36.1.2001.1006.1.20000.27','PCEHR R4 - Discharge Summary - Conformance 3B - HPI-I enforced',105,'2014-01-14 00:00:00.000','HIPS','2014-01-14 00:00:00.000','HIPS')

GO