﻿-- ========================================================
-- Creates and inserts data in the Repository table
-- Inserts data in the DocumentType table
-- Alters the DocumentType Table to add in the RepositoryId
-- ========================================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

--------------------------
-- Create repository table
--------------------------

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[Repository]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[Repository](
    [RepositoryId] [int] NOT NULL,
    [Description] [varchar](50) NOT NULL,
    [RepositoryUniqueId] [varchar](100) NULL,
    [DateCreated] [datetime] NOT NULL,
    [UserCreated] [varchar](256) NOT NULL,
    [DateModified] [datetime] NOT NULL,
    [UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Repository] PRIMARY KEY CLUSTERED 
(
    [RepositoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description (e.g. PCEHR, NPDR)' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository', @level2type=N'COLUMN',@level2name=N'Description'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', N'COLUMN',N'RepositoryUniqueId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'AThe OID that identifies the repository' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository', @level2type=N'COLUMN',@level2name=N'RepositoryUniqueId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'Repository', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies an XDS.b repository to which HIPS can upload and remove documents' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'Repository'
GO




-------------------------
-- Insert repository data
-------------------------

IF NOT EXISTS (SELECT * FROM hips.Repository WHERE RepositoryId = 1)
BEGIN
    INSERT hips.Repository 
        ([RepositoryId]
        ,[Description]
        ,[RepositoryUniqueId]
        ,[DateCreated]
        ,[UserCreated]
        ,[DateModified]
        ,[UserModified])
    VALUES
        (1
        ,'PCEHR'
        ,NULL
        ,GETDATE()
        ,'HIPS'
        ,GETDATE()
        ,'HIPS')  
END

IF NOT EXISTS (SELECT * FROM hips.Repository WHERE RepositoryId = 2)
BEGIN
    INSERT hips.Repository 
        ([RepositoryId]
        ,[Description]
        ,[RepositoryUniqueId]
        ,[DateCreated]
        ,[UserCreated]
        ,[DateModified]
        ,[UserModified])
    VALUES
        (2
        ,'NPDR'
        ,'1.2.36.1.2001.1007.10.8003640002000068'
        ,GETDATE()
        ,'HIPS'
        ,GETDATE()
        ,'HIPS')  
END

----------------------------
-- Alter document type table
----------------------------

IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'RepositoryId' and object_id = OBJECT_ID(N'[hips].[DocumentType]'))
BEGIN
    ALTER TABLE [hips].DocumentType ADD RepositoryId int NULL
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentType_Repository]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentType]'))
ALTER TABLE [hips].[DocumentType]  WITH CHECK ADD  CONSTRAINT [FK_DocumentType_Repository] FOREIGN KEY([RepositoryId])
REFERENCES [hips].[Repository] ([RepositoryId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_DocumentType_Repository]') AND parent_object_id = OBJECT_ID(N'[hips].[DocumentType]'))
ALTER TABLE [hips].[DocumentType] CHECK CONSTRAINT [FK_DocumentType_Repository]
GO
  

----------------------------
-- Insert document type data
----------------------------

UPDATE hips.DocumentType SET RepositoryId = 1
GO

SET IDENTITY_INSERT [hips].[DocumentType] ON
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 1, 'PCEHR Prescription Record', '100.16764', '2013-12-10 00:00:00.000', 'HIPS', '2013-12-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 1, 'PCEHR Dispense Record', '100.16765', '2013-12-10 00:00:00.000', 'HIPS', '2013-12-10 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 1, 'Event Summary', '34133-9', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 1, 'Specialist Letter', '51852-2', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
INSERT INTO [hips].[DocumentType] ([DocumentTypeId], [RepositoryId], [Description], [Code], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 1, 'Shared Health Summary', '60591-5', '2014-01-14 00:00:00.000', 'HIPS', '2014-01-14 00:00:00.000', 'HIPS')
SET IDENTITY_INSERT [hips].[DocumentType] OFF


--Set column to Not Nullable
ALTER TABLE hips.DocumentType ALTER COLUMN RepositoryId int NOT NULL
GO
