﻿-- =============================================
-- Updates the HealthProviderOrgansaition Table to add in the AuthorisedEmployeeName
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO


IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'AuthorisedEmployeeNam' and object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]'))
BEGIN
	ALTER TABLE [hips].HealthProviderOrganisation ADD [AuthorisedEmployeeName] [varchar](100) NULL
END

IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'AuthorisedEmployeeUserId' and object_id = OBJECT_ID(N'[hips].[HealthProviderOrganisation]'))
BEGIN
	ALTER TABLE [hips].HealthProviderOrganisation ADD [AuthorisedEmployeeUserId] [varchar](30) NULL
END

EXEC sp_addextendedproperty N'MS_Description', N'User Name of the Authorised Employee for this HPIO.', 'SCHEMA', N'hips', 'TABLE', N'HealthProviderOrganisation', 'COLUMN', N'AuthorisedEmployeeName'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the Authorised Employee for this HPIO.', 'SCHEMA', N'hips', 'TABLE', N'HealthProviderOrganisation', 'COLUMN', N'AuthorisedEmployeeUserId'
GO
