﻿
-- Create the LogMessage table

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[LogMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[LogMessage](
	[LogMessageId] [int] NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_LogMessage] PRIMARY KEY CLUSTERED 
(
	[LogMessageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LogMessage', N'COLUMN',N'LogMessageId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the log message.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LogMessage', @level2type=N'COLUMN',@level2name=N'LogMessageId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'LogMessage', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description of the log message' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'LogMessage', @level2type=N'COLUMN',@level2name=N'Description'
GO

-- Create the Monitor Tab table

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitorTab]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[MonitorTab](
	[MonitorTabId] [int] NOT NULL,
	[Description] [varchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MonitorTab] PRIMARY KEY CLUSTERED 
(
	[MonitorTabId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTab', N'COLUMN',N'MonitorTabId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identifies the monitor tab.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTab', @level2type=N'COLUMN',@level2name=N'MonitorTabId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTab', N'COLUMN',N'Description'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Description of the monitor tab' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTab', @level2type=N'COLUMN',@level2name=N'Description'
GO

-- Create the Monitor Tab Message table

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [hips].[MonitorTabMessage](
	[MonitorTabId] [int] NOT NULL,
	[LogMessageId] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MonitorTabMessage] PRIMARY KEY CLUSTERED 
(
	[MonitorTabId] ASC
	,[LogMessageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTabMessage', N'COLUMN',N'MonitorTabId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the monitor tab.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTabMessage', @level2type=N'COLUMN',@level2name=N'MonitorTabId'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'hips', N'TABLE',N'MonitorTabMessage', N'COLUMN',N'LogMessageId'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Link to the log message.' , @level0type=N'SCHEMA',@level0name=N'hips', @level1type=N'TABLE',@level1name=N'MonitorTabMessage', @level2type=N'COLUMN',@level2name=N'LogMessageId'
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage]  WITH CHECK ADD  CONSTRAINT [FK_MonitorTabMessage_LogMessage] FOREIGN KEY([LogMessageId])
REFERENCES [hips].[LogMessage] ([LogMessageId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage] CHECK CONSTRAINT [FK_MonitorTabMessage_LogMessage]
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_MonitorTab]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage]  WITH CHECK ADD  CONSTRAINT [FK_MonitorTabMessage_MonitorTab] FOREIGN KEY([MonitorTabId])
REFERENCES [hips].[MonitorTab] ([MonitorTabId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_MonitorTabMessage_MonitorTab]') AND parent_object_id = OBJECT_ID(N'[hips].[MonitorTabMessage]'))
ALTER TABLE [hips].[MonitorTabMessage] CHECK CONSTRAINT [FK_MonitorTabMessage_MonitorTab]
GO


-- Alter the System Error Log Table

IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'LogMessageId' and object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
BEGIN
	ALTER TABLE hips.SystemErrorLog ADD LogMessageId INT NULL
END
GO

-- Add in data to LogMessage Table
-- Add 167 rows to [hips].[LogMessage]
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (0, 'Unknown Log Message', '2013-07-24 23:20:14.313', 'HIPS', '2013-07-24 23:20:14.313', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1, 'BaseDl.Connection - ErrorMessageSqlConnectionError', '2013-07-24 23:20:14.313', 'HIPS', '2013-07-24 23:20:14.313', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (2, 'BaseDl.Command - ErrorMessageSqlConnectionError', '2013-07-24 23:20:14.313', 'HIPS', '2013-07-24 23:20:14.313', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (3, 'PatientMasterAddressDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.317', 'HIPS', '2013-07-24 23:20:14.317', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (4, 'AddressDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.317', 'HIPS', '2013-07-24 23:20:14.317', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (5, 'AddressDl.GetAllByPatient() - Unexpected Exception', '2013-07-24 23:20:14.317', 'HIPS', '2013-07-24 23:20:14.317', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (6, 'ContactDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.320', 'HIPS', '2013-07-24 23:20:14.320', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (7, 'ContactDl.GetAllByPatient() - Unexpected Exception', '2013-07-24 23:20:14.320', 'HIPS', '2013-07-24 23:20:14.320', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (8, 'HospitalCodeDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.323', 'HIPS', '2013-07-24 23:20:14.323', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (9, 'PatientMasterNameDl.GetAllByPatient() - Unexpected Exception', '2013-07-24 23:20:14.323', 'HIPS', '2013-07-24 23:20:14.323', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 'HL7MessageLogDl.Get() - Unexpected Exception - Gets the specified HL7MessageLog id.', '2013-07-24 23:20:14.323', 'HIPS', '2013-07-24 23:20:14.323', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (11, 'DownloadedDocumentDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.327', 'HIPS', '2013-07-24 23:20:14.327', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 'DownloadedDocumentDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.330', 'HIPS', '2013-07-24 23:20:14.330', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (13, 'EpisodeLifecycleDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.330', 'HIPS', '2013-07-24 23:20:14.330', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, 'EpisodeLifecycleDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.330', 'HIPS', '2013-07-24 23:20:14.330', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (15, 'ClinicalDocumentVersionDl.GetAllVersions() - Unexpected Exception', '2013-07-24 23:20:14.333', 'HIPS', '2013-07-24 23:20:14.333', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (16, 'ClinicalDocumentVersionDl.GetLatestVersion() - Unexpected Exception', '2013-07-24 23:20:14.333', 'HIPS', '2013-07-24 23:20:14.333', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (17, 'ClinicalDocumentVersionDl.GetVersion() - Unexpected Exception', '2013-07-24 23:20:14.337', 'HIPS', '2013-07-24 23:20:14.337', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (18, 'DocumentFormatDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.337', 'HIPS', '2013-07-24 23:20:14.337', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (19, 'DocumentFormatDL.Get() - Unexpected Exception', '2013-07-24 23:20:14.337', 'HIPS', '2013-07-24 23:20:14.337', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (20, 'StateDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.337', 'HIPS', '2013-07-24 23:20:14.337', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (21, 'StateDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.337', 'HIPS', '2013-07-24 23:20:14.337', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (22, 'TitleDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.340', 'HIPS', '2013-07-24 23:20:14.340', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (23, 'TitleDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.340', 'HIPS', '2013-07-24 23:20:14.340', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (24, 'SuffixDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.340', 'HIPS', '2013-07-24 23:20:14.340', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (25, 'SuffixDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.340', 'HIPS', '2013-07-24 23:20:14.340', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (26, 'DocumentTypeDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.340', 'HIPS', '2013-07-24 23:20:14.340', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (27, 'DocumentTypeDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.340', 'HIPS', '2013-07-24 23:20:14.340', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (28, 'MedicareExclusionDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (29, 'MedicareExclusionDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (30, 'SexDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (31, 'SexDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (32, 'EpisodeTypeDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (33, 'EpisodeTypeDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (34, 'CodeSystemDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.343', 'HIPS', '2013-07-24 23:20:14.343', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (35, 'CodeSystemDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.347', 'HIPS', '2013-07-24 23:20:14.347', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (36, 'ClinicalDocumentDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.347', 'HIPS', '2013-07-24 23:20:14.347', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (37, 'ClinicalDocumentDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.347', 'HIPS', '2013-07-24 23:20:14.347', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (38, 'RemovalStatusDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.347', 'HIPS', '2013-07-24 23:20:14.347', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (39, 'AddressTypeDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.347', 'HIPS', '2013-07-24 23:20:14.347', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (40, 'AddressTypeDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.347', 'HIPS', '2013-07-24 23:20:14.347', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (41, 'CountryDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (42, 'CountryDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (43, 'HealthProviderIndividualDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (44, 'HealthProviderIndividualDl.GetByPasIdentifier() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (45, 'HealthProviderIndividualDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (46, 'PatientMasteIhirDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (47, 'PatientMasteIhirDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (48, 'HealthProviderOrganisationPatientDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (49, 'HealthProviderOrganisationPatientDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.350', 'HIPS', '2013-07-24 23:20:14.350', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (50, 'HospitalPatientDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (51, 'EpisodeDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (52, 'PcehrMessageQueueDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (53, 'PcehrMessageQueueDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (54, 'PatientMasterDl.GetByHospitalCodeMrn() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (55, 'PatientMasterDl.GetByHospitalIdMrn() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (56, 'PatientMasterDl.GetByDemographics() - Unexpected Exception', '2013-07-24 23:20:14.353', 'HIPS', '2013-07-24 23:20:14.353', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (57, 'PatientMasterDl.GetByIhi() - Unexpected Exception', '2013-07-24 23:20:14.357', 'HIPS', '2013-07-24 23:20:14.357', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (58, 'PatientMasterDl.GetByStatePatientId() - Unexpected Exception', '2013-07-24 23:20:14.357', 'HIPS', '2013-07-24 23:20:14.357', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (59, 'PatientMasterDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.357', 'HIPS', '2013-07-24 23:20:14.357', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (60, 'PatientMasterDl.Insert() - Unexpected Exception', '2013-07-24 23:20:14.357', 'HIPS', '2013-07-24 23:20:14.357', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (61, 'PatientMasterDl.Update() - Unexpected Exception', '2013-07-24 23:20:14.357', 'HIPS', '2013-07-24 23:20:14.357', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (62, 'PatientMasterDl.Merge() - Unexpected Exception', '2013-07-24 23:20:14.357', 'HIPS', '2013-07-24 23:20:14.357', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (63, 'HospitalDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (64, 'HospitalDl.Get() - Unexpected Exception - Gets the specified hospital id.', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (65, 'HospitalDl.Get() - Unexpected Exception - Gets the specified hospital from the Code.', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (66, 'PatientAccess.ReadCreateOrUpdatePatient() - Unexpected Exception - UnableToInsertPatientStub', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (67, 'DocumentQueueTransactionHandler.SaveRemoveOperationAndPlaceOnQueue() - Unexpected Exception - ErrorAddingRemoveOperationToMsmq', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (68, 'DocumentQueueTransactionHandler.SaveRemoveOperationAndPlaceOnQueue() - Unexpected Exception - ErrorInsertingRemoveOperation', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (69, 'DocumentQueueTransactionHandler.SaveUploadOperationAndPlaceOnQueue() - Unexpected Exception - ErrorAddingUploadOperationToMsmq', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (70, 'DocumentQueueTransactionHandler.SaveUploadOperationAndPlaceOnQueue() - Unexpected Exception - ErrorInsertingUploadOperation', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (71, 'DocumentQueueTransactionHandler.SaveAfterSuccessfulUpload() - Unexpected Exception - ErrorSuccessfulUploadSave', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (72, 'DocumentQueueTransactionHandler.SaveAfterSuccessfulRemove() - Unexpected Exception - ErrorSuccessfulRemoveSave', '2013-07-24 23:20:14.360', 'HIPS', '2013-07-24 23:20:14.360', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (73, 'DocumentQueueTransactionHandler.RestorePackageInQueuedUploadOperatione() - Unexpected Exception - CouldNotReloadPackage', '2013-07-24 23:20:14.363', 'HIPS', '2013-07-24 23:20:14.363', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (74, 'PatientIhiCleanup.Cleanup() - InfoIhiCleanupStart', '2013-07-24 23:20:14.363', 'HIPS', '2013-07-24 23:20:14.363', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (75, 'PatientIhiCleanup.Cleanup() - ErrorIhiCleanupEncounteredError', '2013-07-24 23:20:14.363', 'HIPS', '2013-07-24 23:20:14.363', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (76, 'PatientIhiCleanup.Cleanup() - InfoIhiCleanupFinish', '2013-07-24 23:20:14.363', 'HIPS', '2013-07-24 23:20:14.363', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (77, 'PatientIhiCleanup.ReachedThresholdOnConsecutiveUnavailable() - InfoIhiCleanupSleep', '2013-07-24 23:20:14.363', 'HIPS', '2013-07-24 23:20:14.363', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (78, 'DocumentRemoval.Remove() - InfoQueuedOperationAborted', '2013-07-24 23:20:14.363', 'HIPS', '2013-07-24 23:20:14.363', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (79, 'DocumentRemoval.Remove() - InfoRemovalWithStaleIhiBeingRetried', '2013-07-24 23:20:14.367', 'HIPS', '2013-07-24 23:20:14.367', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (80, 'PatientIhiValidation.GetValidatedIhi() - ReturningStaleIhi', '2013-07-24 23:20:14.367', 'HIPS', '2013-07-24 23:20:14.367', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (81, 'PatientIhiValidation.GetValidatedIhi() -  Unexpected Exception', '2013-07-24 23:20:14.367', 'HIPS', '2013-07-24 23:20:14.367', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (82, 'PatientIhiValidation.GetValidatedIhi() -  Attempted access with incorrect user details', '2013-07-24 23:20:14.367', 'HIPS', '2013-07-24 23:20:14.367', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (83, 'PatientIhiValidation.GetValidatedIhi() -  Unknown patient record', '2013-07-24 23:20:14.367', 'HIPS', '2013-07-24 23:20:14.367', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (84, 'PatientIhiValidation.GetValidatedIhi() -  Incorrect date of birth could be due to unauthorised access', '2013-07-24 23:20:14.367', 'HIPS', '2013-07-24 23:20:14.367', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (85, 'DocumentRemovalBeforeQueue.LoadPatientEpisode() - InfoRemoveQueuedWithStaleIhi', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (86, 'DocumentUpload.PerformUpload() - InfoQueuedOperationAborted', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (87, 'DocumentUpload.PerformUpload() - InfoUploadWithStaleIhiBeingRetried - roll back the queue transaction', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (88, 'DemographicCheck.ValidateDemographics() - Demographic Mismatch', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (89, 'DoesPcehrExist.PcehrExists() -  Unexpected Exception', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (90, 'DoesPcehrExist.InvokeDoesPcehrExist() - FaultException<StandardErrorType>', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (91, 'DoesPcehrExist.InvokeDoesPcehrExist() - ErrorUnableToConnectDoesPcehrExist', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (92, 'DocumentUploadBeforeQueue.UploadOrSupersedeDocument() - InfoUploadQueuedWithStaleIhi', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (93, 'DocumentUploadBeforeQueue.UploadOrSupersedeDocument() - InfoConsentWithdrawn', '2013-07-24 23:20:14.370', 'HIPS', '2013-07-24 23:20:14.370', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (94, 'DocumentUploadBeforeQueue.UploadOrSupersedeDocument() - InfoPatientUnderAge', '2013-07-24 23:20:14.373', 'HIPS', '2013-07-24 23:20:14.373', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (95, 'DocumentUploadBeforeQueue.ValidateInput() - NoCdaDocument', '2013-07-24 23:20:14.373', 'HIPS', '2013-07-24 23:20:14.373', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (96, 'DocumentUploadBeforeQueue.ValidateInput() - RetrieveHospitalFailed', '2013-07-24 23:20:14.373', 'HIPS', '2013-07-24 23:20:14.373', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (97, 'DocumentUploadBeforeQueue.ValidateInput() - RetrievePatientFailed', '2013-07-24 23:20:14.373', 'HIPS', '2013-07-24 23:20:14.373', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (98, 'DocumentUploadBeforeQueue.ValidateInput() - RetrieveEpisodeFailed', '2013-07-24 23:20:14.373', 'HIPS', '2013-07-24 23:20:14.373', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (99, 'DocumentUploadBeforeQueue.ValidateInput() - DocumentFormatNotFound', '2013-07-24 23:20:14.373', 'HIPS', '2013-07-24 23:20:14.373', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (100, 'DocumentUploadBeforeQueue.PackageDocument() - CdaPackagingException InvalidCda', '2013-07-24 23:20:14.377', 'HIPS', '2013-07-24 23:20:14.377', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (101, 'DocumentUploadBeforeQueue.PackageDocument() - Unexpected Exception', '2013-07-24 23:20:14.377', 'HIPS', '2013-07-24 23:20:14.377', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (102, 'DocumentUploadBeforeQueue.ValidateAttachments() - AttachmentTooLarge', '2013-07-24 23:20:14.377', 'HIPS', '2013-07-24 23:20:14.377', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (103, 'DocumentUploadBeforeQueue.ValidateAttachments() - ArgumentException - AttachmentFilenameInvalid', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (104, 'DocumentUploadBeforeQueue.ValidateAttachments() - AttachmentTypeDisallowed', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (105, 'DocumentRemovalInvoker.HandlePcehrResponse() - unable to connect to the PCEHR or the service was temporarily unavailable', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (106, 'DocumentUploadInvoker.HandlePcehrResponse() - PcehrSystemTemporarilyUnavailable', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (107, 'MessageLoader.Process() - IhiInfoException Data message processed but quality issue looking for IHI', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (108, 'MessageLoader.Process() - IhiErrorException message processed but serious failure while looking for IHI', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (109, 'MessageLoader.Process() - HL7MessageInfoException message not processed data quality issue', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (110, 'MessageLoader.Process() - HL7MessageErrorException message not processed message should be retried', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (111, 'MessageLoader.Process() - Unexpected Exception message not processed message should be retried', '2013-07-24 23:20:14.380', 'HIPS', '2013-07-24 23:20:14.380', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (112, 'PatientLoader.PopulateSecondaryDemographics() - InfoMessageDateOfDeathBeforeSQLDateMin', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (113, 'CheckPatientParticipation.GetRecentPatientParticipationStatus() - InfoPatientParticipation', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (114, 'DatabaseLoaderService.NotifyPasEvent() - HL7ParseException', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (115, 'DatabaseLoaderService.NotifyPasEvent() - Unexpected Exception', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (116, 'IhiCleanUpServiceHost.InitializeRuntime() - Background Thread Started', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (117, 'IhiCleanUpServiceHost.RunThread() - Interval Message', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (118, 'IhiCleanUpServiceHost.IhiCleanUpServiceHost_IhiCleanUpCallback - Error restarting timer 1', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (119, 'IhiCleanUpServiceHost.IhiCleanUpServiceHost_IhiCleanUpCallback - Error restarting timer 2', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (120, 'ReferenceService.ReloadReferenceData() - Reference Data Reloaded', '2013-07-24 23:20:14.383', 'HIPS', '2013-07-24 23:20:14.383', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (121, 'ReferenceService.ReloadReferenceData() - Unexpected Exception', '2013-07-24 23:20:14.387', 'HIPS', '2013-07-24 23:20:14.387', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (122, 'PatientMasteIhiDl.Update() - Unexpected Exception', '2013-07-24 23:20:14.387', 'HIPS', '2013-07-24 23:20:14.387', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (123, 'PatientMasteIhiDl.GetTimesIhiUsed() - Unexpected Exception', '2013-07-24 23:20:14.387', 'HIPS', '2013-07-24 23:20:14.387', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (124, 'PatientMasteIhiDl.GetTimesIhiUsed() - Null or Empty ihi passed so no ihi usage count', '2013-07-24 23:20:14.387', 'HIPS', '2013-07-24 23:20:14.387', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (125, 'PatientMasteIhiDl.GetPossibleDuplicatePatients() - Unexpected Exception', '2013-07-24 23:20:14.387', 'HIPS', '2013-07-24 23:20:14.387', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (126, 'HospitalPatientDl.GetAllActive() - Unexpected Exception', '2013-07-24 23:20:14.387', 'HIPS', '2013-07-24 23:20:14.387', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (127, 'HospitalPatientDl.GetActive() - Unexpected Exception', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (128, 'HospitalPatientDl.Get() - Unexpected Exception - Gets the specified hospital patient by patient id.', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (129, 'HospitalPatientDl.Get() - Unexpected Exception - Gets the specified patient by hospital id and Mrn.', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (130, 'HospitalPatientDl.Move() - Unexpected Exception', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (131, 'HL7MessageLogDl.Get() - Unexpected Exception - Gets the HL7 Message Log entry with the specified parameters', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (132, 'ContactDl.GetAllByHospital() - Unexpected Exception', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (133, 'HospitalAddressDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1001, 'ComplicationDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.390', 'HIPS', '2013-07-24 23:20:14.390', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1002, 'ConsentAudit.GetCurrentConsentAudit() - Unexpected Exception', '2013-07-24 23:20:14.393', 'HIPS', '2013-07-24 23:20:14.393', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1003, 'DiagnosisDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.393', 'HIPS', '2013-07-24 23:20:14.393', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1004, 'DiagnosisDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.393', 'HIPS', '2013-07-24 23:20:14.393', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1005, 'DisclosureAuditDl.GetCurrentDisclosureAudit() - Unexpected Exception', '2013-07-24 23:20:14.393', 'HIPS', '2013-07-24 23:20:14.393', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1006, 'EpisodeDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.393', 'HIPS', '2013-07-24 23:20:14.393', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1007, 'EpisodeDl.GetEpisodesWithUploadedDocuments() - Unexpected Exception', '2013-07-24 23:20:14.393', 'HIPS', '2013-07-24 23:20:14.393', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1008, 'EpisodeDl.GetEpisodesWithUploadedDocumentCount() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1009, 'EpisodeDl.GetEpisodes() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1010, 'EpisodeDl.GetEpisodesCount() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1011, 'EpisodeDl.Update() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1012, 'EpisodeIhiCheckListDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1013, 'HelpPageDl.List() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1014, 'HospitalDl.GetActive() - Unexpected Exception', '2013-07-24 23:20:14.397', 'HIPS', '2013-07-24 23:20:14.397', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1015, 'HospitalWardDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1016, 'MenuDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1017, 'PatientDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1018, 'PatientDl.PatientsWithoutIhi() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1019, 'PatientDl.PatientsWithIhi() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1020, 'PatientDl.PatientsWithOverridesReport() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1021, 'PatientMasterDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1022, 'PatientMasterDl.Insert() - Unexpected Exception', '2013-07-24 23:20:14.400', 'HIPS', '2013-07-24 23:20:14.400', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1023, 'PatientMasterDl.Update() - Unexpected Exception', '2013-07-24 23:20:14.403', 'HIPS', '2013-07-24 23:20:14.403', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1024, 'PatientTileDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.403', 'HIPS', '2013-07-24 23:20:14.403', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1025, 'PatientTileDl.GetByMrn() - Unexpected Exception', '2013-07-24 23:20:14.403', 'HIPS', '2013-07-24 23:20:14.403', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1026, 'RemoveAuditDl.GetCurrentRemoveAudit() - Unexpected Exception', '2013-07-24 23:20:14.403', 'HIPS', '2013-07-24 23:20:14.403', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1027, 'SecurityDl.GetUserPermission() - Unexpected Exception', '2013-07-24 23:20:14.403', 'HIPS', '2013-07-24 23:20:14.403', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1028, 'SecurityDl.CreateUserPermission() - Unexpected Exception', '2013-07-24 23:20:14.403', 'HIPS', '2013-07-24 23:20:14.403', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1029, 'SecurityDl.GetHadGroups() - Unexpected Exception - PUMA_LOCAL_SECURITY', '2013-07-24 23:20:14.407', 'HIPS', '2013-07-24 23:20:14.407', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1030, 'SecurityDl.GetHadGroups() - Unexpected Exception - PUMA_AD_SECURITY', '2013-07-24 23:20:14.407', 'HIPS', '2013-07-24 23:20:14.407', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1031, 'SeparationLocationDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.407', 'HIPS', '2013-07-24 23:20:14.407', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1032, 'SeparationLocationDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.407', 'HIPS', '2013-07-24 23:20:14.407', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1033, 'SpecialityDl.GetAll() - Unexpected Exception', '2013-07-24 23:20:14.407', 'HIPS', '2013-07-24 23:20:14.407', 'HIPS')
INSERT INTO [hips].[LogMessage] ([LogMessageId], [Description], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (1034, 'SpecialityDl.Get() - Unexpected Exception', '2013-07-24 23:20:14.407', 'HIPS', '2013-07-24 23:20:14.407', 'HIPS')
GO

--set existing items to 0
UPDATE hips.SystemErrorLog SET LogMessageId=0 WHERE LogMessageId IS NULL
GO
--change value to not nullable
DECLARE @Command NVARCHAR(256);
SET @Command = N'ALTER TABLE hips.SystemErrorLog ALTER COLUMN [LogMessageId] INT NOT NULL';
EXECUTE (@Command);
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SystemErrorLog_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
ALTER TABLE [hips].[SystemErrorLog]  WITH CHECK ADD  CONSTRAINT [FK_SystemErrorLog_LogMessage] FOREIGN KEY([LogMessageId])
REFERENCES [hips].[LogMessage] ([LogMessageId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hips].[FK_SystemErrorLog_LogMessage]') AND parent_object_id = OBJECT_ID(N'[hips].[SystemErrorLog]'))
ALTER TABLE [hips].[SystemErrorLog] CHECK CONSTRAINT [FK_SystemErrorLog_LogMessage]
GO
DROP PROCEDURE [hips].[SystemErrorLogInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 15 October 2012
-- Description:   Inserts a new record into the System Error Log Table
-- Modified: 24/07/2013 - Simon Biber - Added LogMessageId column
-- =============================================
CREATE PROCEDURE [hips].[SystemErrorLogInsert] 
(
      @LogMessageId INT
	, @Message VARCHAR(200)
	, @ExceptionMessage VARCHAR(500) = NULL
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON
	INSERT INTO hips.SystemErrorLog
	(
		  [LogMessageId]
		, [Message]
		, [ExceptionMessage]
        , [DateCreated]
        , [UserCreated]
        , [DateModified]
        , [UserModified]
	)
VALUES
	(
		  @LogMessageId
		, @Message
		, @ExceptionMessage
        , GETDATE()
        , @UserModified
        , GETDATE()
        , @UserModified
	)

END
GO
GRANT EXECUTE ON [hips].[SystemErrorLogInsert] TO [RunStoredProcedure]
GO

/****** Object:  StoredProcedure [puma].[PatientsWithoutIhiReport]    Script Date: 06/20/2013 10:12:00 ******/
DROP PROCEDURE [puma].[PatientsWithoutIhiReport]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew Jacks
-- Create date:   4 December 2012
-- Description:   Gets a list of patients without IHI's for reporting
-- Modified: 15-May-13 Kirby Bettison - Added clause to remove patients with an IHI
--           19-Jul-13 Simon Biber    - Fix brackets on IHI clause, exclude Medicare Exclusions, exclude patients under 1 month old, exclude patients discharged more than given number of days ago
--           25-Jul-13 Simon Biber    - Display 'Discharged' in place of the Ward when the patient has been discharged
-- =============================================
CREATE PROCEDURE [puma].[PatientsWithoutIhiReport] 
(
	@HospitalId INT = NULL,
	@NumberOfDaysAfterDischarge INT = 0
)
AS
BEGIN
SELECT 	ptv.GivenNames,
		ptv.FamilyName,
		ptv.Mrn,
	    s.Description AS Sex,
	    pm.MedicareNumber,
	    pm.MedicareIrn,
	    pm.DvaNumber,
		ptv.DateOfBirth,
		CASE WHEN ptv.DischargeDate < GETDATE() 
		THEN '*Discharged' 
		WHEN ptv.Ward IS NULL OR ptv.Ward=''
		THEN '*Unknown'
		ELSE ptv.Ward END AS Ward		
FROM  puma.PatientTileView ptv
LEFT OUTER JOIN hips.PatientMaster pm on pm.PatientMasterId = ptv.PatientMasterId
LEFT OUTER JOIN hips.Sex s on s.SexId = pm.CurrentSexId
WHERE (ptv.HospitalId = @HospitalId OR @HospitalId IS NULL)
AND   (ptv.IhiInvestigationComplete != 1 OR ptv.IhiInvestigationComplete IS NULL)
AND    ptv.AdmissionDate IS NOT NULL
AND	  (ptv.Ihi IS NULL OR ptv.Ihi = '')
AND NOT EXISTS (SELECT * FROM [hips].MedicareExclusion Where MedicareNumber = ptv.MedicareNumber)
AND ptv.DateOfBirth < DATEADD(m, -1, GETDATE())
AND (ptv.DischargeDate IS NULL OR ptv.DischargeDate > DATEADD(DAY, -@NumberOfDaysAfterDischarge, GETDATE()))
ORDER BY ptv.FamilyName, ptv.GivenNames

END
GO

GO
GRANT EXECUTE ON [puma].[PatientsWithoutIhiReport] TO [RunStoredProcedure]
GO