﻿IF NOT EXISTS (SELECT * from sys.columns WHERE name = 'UploadDocumentMinimumAge' and object_id = OBJECT_ID(N'[hips].[Hospital]'))
BEGIN
	ALTER TABLE hips.Hospital ADD UploadDocumentMinimumAge INT NULL
END
GO
DROP PROCEDURE [hips].[HospitalGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date:   24 July 2012
-- Description:   Gets one or more specified records from the Hospital Table.
--                Provide a HospitalId or both a Code and a CodeSystemId.
-- Modified: 
-- 18/12/2012 sbiber added Logo and HealthProviderOrganisationId
-- 24/01/2013 sbiber added Code, CodeSystemId and DateModified to match DL
-- 05/07/2013 sbiber added UploadDocumentMinimumAge
-- =============================================
CREATE PROCEDURE [hips].[HospitalGet] 
(
	   @HospitalId INT = NULL
	   ,@Code VARCHAR(64) = NULL
	   ,@CodeSystemId INT = NULL
	   ,@DateModified DATETIME = NULL
) AS
BEGIN

IF @HospitalId IS NULL AND @Code IS NOT NULL AND @CodeSystemId IS NOT NULL
BEGIN
	SELECT	@HospitalId = HospitalId
	FROM	hips.HospitalCode
	WHERE	Code = @Code
		AND	CodeSystemId = @CodeSystemId
END

SELECT DISTINCT
		h.HospitalId,		
		h.Description,
		h.Name,
		hpo.Name AS HpioName,
		hpo.HpiO AS HpiO,
		hpo.HiCertSerial AS HiCertSerial,
		hpo.PcehrCertSerial AS PcehrCertSerial,
		h.AuthorisedEmployeeName,
		h.AuthorisedEmployeeUserId,
		h.Logo,
		h.HealthProviderOrganisationId,
		h.UploadDocumentMinimumAge,
		h.DateCreated,
		h.UserCreated,
		h.DateModified,
		h.UserModified
		
FROM		hips.Hospital h
LEFT JOIN	hips.HealthProviderOrganisation hpo
ON			h.HealthProviderOrganisationId = hpo.HealthProviderOrganisationId
WHERE (@HospitalId IS NULL  OR h.HospitalId = @HospitalId)
AND (@DateModified IS NULL OR h.DateModified >= @DateModified)

END
GO
GRANT EXECUTE ON [hips].[HospitalGet] TO [RunStoredProcedure]
GO
UPDATE hips.Hospital SET UploadDocumentMinimumAge = 18
GO