﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.BusinessEntities.ResponseEntities;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.Reference.ServiceContracts
{
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IHIPSReferenceService")]
    public interface IHIPSReferenceService
    {
        /// <summary>
        /// Find all known information about a hospital, such as:
        /// <list identifier="bullet">
        /// <item>Description and Name</item>
        /// <item>Address</item>
        /// <item>Fax Number</item>
        /// <item>List of Identifiers (HPI-O, OID for MRNs, OID for Provider Identifers, ISAAC)</item>
        /// </list>
        /// </summary>
        /// <param name="identifier">An identifier for the hospital</param>
        /// <param name="identifierNamespace">The namespace of the identifier supplied</param>
        /// <returns>The hospital details</returns>
        [OperationContract]
        HospitalDetailResponse GetHospitalDetails(string identifier, string codeSystemName);

        /// <summary>
        /// Reloads all the reference data from the database.
        /// See <see cref="HIPS.CommonBusinessLogic.Singleton.ListSingleton"/> for
        /// further details of which reference data is loaded.
        /// </summary>
        /// <param name="user">User details</param>
        /// <returns>Indicator of success or failure</returns>
        [OperationContract]
        HipsResponse ReloadReferenceData(UserDetails user);

        /// <summary>
        /// Lists the hospitals.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<Hospital> ListHospitals();

    }
}