﻿using System.Collections.Generic;
using HIPS.AppServer.ServiceHost;
using HIPS.CommonSchemas.Hi;
using HIPS.PcehrHiBusinessLogic.Hi;
using HIPS.Reference.ServiceContracts;

namespace HIPS.Reference.ServiceHost
{
    public class HiReferenceService : BaseService, IHiReferenceService
    {
        /// <summary>
        /// Gets the StreetSuffixTypes List.
        /// </summary>
        /// <returns></returns>
        public List<HiStreetSuffixType> GetHiStreetSuffixTypes()
        {
            return new HiReference().GetHiStreetSuffixTypes();
        }

        /// <summary>
        /// Gets the street types.
        /// </summary>
        /// <returns></returns>
        public List<HiStreetType> GetHiStreetTypes()
        {
            return new HiReference().GetHiStreetTypes();
        }

        /// <summary>
        /// Gets the UnitType List.
        /// </summary>
        /// <returns></returns>
        public List<HiUnitType> GetHiUnitTypes()
        {
            return new HiReference().GetHiUnitTypes();
        }

        /// <summary>
        /// Gets the LevelType List.
        /// </summary>
        /// <returns></returns>
        public List<HiLevelType> GetHiLevelTypes()
        {
            return new HiReference().GetHiLevelTypes();
        }

        /// <summary>
        /// Gets the PostalDeliveryType List.
        /// </summary>
        /// <returns></returns>
        public List<HiPostalDeliveryType> GetHiPostalDeliveryTypes()
        {
            return new HiReference().GetHiPostalDeliveryTypes();
        }

        /// <summary>
        /// Gets the State List.
        /// </summary>
        /// <returns></returns>
        public List<HiState> GetHiStates()
        {
            return new HiReference().GetHiStates();
        }

        /// <summary>
        /// Gets the Country List.
        /// </summary>
        /// <returns></returns>
        public List<HiCountry> GetHiCountries()
        {
            return new HiReference().GetHiCountries();
        }

        /// <summary>
        /// Gets the Sex List.
        /// </summary>
        /// <returns></returns>
        public List<HiSex> GetHiSexes()
        {
            return new HiReference().GetHiSexes();
        }
    }
}