﻿#region Using Directives

using System;
using System.Collections.Generic;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;
using Nehta.VendorLibrary.PCEHR;
using HIPS.PcehrDataStore.Schemas;

#endregion Using Directives

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IAssistedRegistrationService")]
    public interface IAssistedRegistrationService
    {
        /// <summary>
        /// Lists the patients without pcehr.
        /// </summary>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <returns>List of patients without a PCEHR</returns>
        [OperationContract]
        PatientWithoutPcehrResponse ListPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode = null);

        /// <summary>
        /// Registers the patient.
        /// </summary>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        [OperationContract]
        PcehrRegistrationResponse RegisterPatient(PatientIdentifierBase patientIdentifier, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, UserDetails user, Attachment consentForm = null);

        /// <summary>
        /// Reregisters the patient.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier.</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        [OperationContract]
        PcehrRegistrationResponse ReregisterPatient(int patientMasterId, PatientIdentifierBase patientIdentifier, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, UserDetails user, Attachment consentForm = null);

        /// <summary>
        /// Registers the dependant.
        /// </summary>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="representativeDemographics">The representative demographics.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        [OperationContract]
        PcehrRegistrationResponse RegisterDependant(PatientIdentifierBase patientIdentifier, Demographic representativeDemographics, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, bool representativeDeclaration, UserDetails user, Attachment consentForm = null);

        /// <summary>
        /// Reregisters the dependant.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier.</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="representativeDemographics">The representative demographics.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">The user.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns></returns>
        [OperationContract]
        PcehrRegistrationResponse ReregisterDependant(int patientMasterId, PatientIdentifierBase patientIdentifier, Demographic representativeDemographics, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, bool representativeDeclaration, UserDetails user, Attachment consentForm = null);

    }
}