﻿#region Using Directives

using System;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;

#endregion Using Directives

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IHIService")]
    public interface IIHIService
    {
        /// <summary>
        /// Obtains validated IHI information for use in a clinical document.
        /// </summary>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="dateOfBirth">Patient's date of birth (for identity verification)</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        [OperationContract]
        ValidatedIhiResponse GetValidatedIhi(PatientIdentifierBase patientIdentifier, DateTime dateOfBirth, UserDetails user);

        /// <summary>
        /// This is a legacy interface into GetValidatedIhi that accepts only an MRN and not any other type of patient identifier.
        /// TODO: Remove this method when HIB code has been refactored to use GetValidatedIhi
        /// </summary>
        /// <param name="hospitalIdentifier">Code identifying the hospital</param>
        /// <param name="codeSystemName">Type of code identifying the hospital</param>
        /// <param name="mrn">Patient identifier unique within the hospital</param>
        /// <param name="dateOfBirth">Patient's date of birth (for identity verification)</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        //[OperationContract]
        //IhiSearchResponse IhiSearchByMrn(string hospitalIdentifier, string codeSystemName, string mrn, DateTime dateOfBirth, UserDetails user);
    }
}