﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.PatientSchemas;

#endregion Using Directives

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IPatientService")]
    public interface IPatientService
    {
        /// <summary>
        /// Lists admitted or recently discharged patients in hospital with or without a PCEHR.
        /// </summary>
        /// <param name="user">The user who is requesting the information.</param>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="withPcehr">True to list patients with a PCEHR, false to list patients without a PCEHR. Null to include patients with or without a PCEHR.</param>
        /// <param name="daysDischarged">Number of days after discharge that patients are included in the list. Set to 0 to list only currently admitted patients.</param>
        /// <returns>A patient list response with status and a list of patients in hospital.</returns>
        [OperationContract]
        PatientListResponse ListPatientsInHospital(UserDetails user, string hospitalCodeSystem, string hospitalCode, bool? withPcehr, int daysDischarged);
    }
}