﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using IhiPcehrCommonSchemas;

namespace IhiPcehrCommonBusinessLogic
{
    public static class Helpers
    {
        /// <summary>
        /// Validates the user has all the required fields populated.
        /// </summary>
        /// <param name="user">The user details</param>
        /// <returns>whether valid</returns>
        static public bool ValidateUser(UserDetails user)
        {
            if (string.IsNullOrEmpty(user.Name))
            {
                return false;
            }
            switch (user.Role)
            {
                case UserRole.AuthorisedEmployee:
                    if (string.IsNullOrEmpty(user.AuthorisedEmployeeUserId))
                    {
                        return false;
                    }
                    break;
                case UserRole.InteractiveUser:
                    if (string.IsNullOrEmpty(user.Domain) || string.IsNullOrEmpty(user.Login))
                    {
                        return false;
                    }
                    break;
                case UserRole.ProviderIndividual:
                    if (string.IsNullOrEmpty(user.HpiI))
                    {
                        return false;
                    }
                    break;
            }
            return true;
        }
    }
}
