﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using Nehta.VendorLibrary.Common;
using System.Net;
using System.Configuration;
using Nehta.VendorLibrary.PCEHR;
using System.ServiceModel;
using System.Net.Security;
using Nehta.VendorLibrary.PCEHR.PCEHRProfile;
using IhiPcehrCommonSchemas;
using PcehrBusinessLogic;
using HIPS.PcehrDataStore.DataAccess;
using PcehrSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace PcehrBusinessLogic
{
    public class DoesPcehrExist
    {

        #region Events
        /// <summary>
        /// Validates the service certificate. - Not sure if we need to do anything here
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="certificate">The certificate.</param>
        /// <param name="chain">The chain.</param>
        /// <param name="sslPolicyErrors">The SSL policy errors.</param>
        /// <returns></returns>
        private bool ValidateServiceCertificate(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            // Checks can be done here to validate the service certificate.
            // If the service certificate contains any problems or is invalid, return false. Otherwise, return true.
            // This example returns true to indicate that the service certificate is valid.
            return true;
        }
        #endregion
        #region Methods


        /// <summary>
        /// Builds the request.
        /// </summary>
        /// <param name="ihiNumber">The ihi number.</param>
        /// <returns></returns>
        private DoesPcehrExistResponse Search(string ihiNumber, Uri endpoint, X509Certificate2 certificate, UserDetails user)
        {
            DoesPcehrExistResponse result = new DoesPcehrExistResponse();
            bool checkService = bool.Parse(ConfigurationManager.AppSettings["CheckDoesPcehrExist"].ToString());
            if (!checkService)
            {
                result.Status = PcehrExistsReturnStatus.OK;
                return result;
            }
            CommonPcehrHeader pcehrHeader = Helpers.GetHeader(ihiNumber, user);

            DoesPCEHRExistClient doesPcehrExistClient = new DoesPCEHRExistClient(endpoint, certificate, certificate);
            ServicePointManager.ServerCertificateValidationCallback += ValidateServiceCertificate;

            StringBuilder errorMessages = new StringBuilder();

            try
            {
                // Invoke the service
                doesPCEHRExistResponse response = doesPcehrExistClient.DoesPCEHRExist(pcehrHeader);
                result.Status = PcehrExistsReturnStatus.OK;
                result.PcehrExists = response.PCEHRExists;
                result.AccessCodeRequired = response.accessCodeRequired;
                result.AccessCodeRequiredSpecified = response.accessCodeRequiredSpecified;
            }


            catch (FaultException<StandardErrorType> ex)
            {
                errorMessages.Append(string.Format("[{0}] {1}", ex.Detail.errorCode, ex.Detail.message));
                EventLogger.WriteLog(errorMessages.ToString(), ex);
            }
            catch (Exception ex)
            {
   
                if (ex.InnerException != null)
                {
                    errorMessages.AppendLine(ex.InnerException.Message);
                }
                errorMessages.Append(ex.Message);
                EventLogger.WriteLog(errorMessages.ToString(), ex);
            }
            return result;
        }

        /// <summary>
        /// Pcehrs the exists.
        /// </summary>
        /// <param name="ihi">The ihi.</param>
        /// <returns></returns>
        public  DoesPcehrExistResponse PcehrExists(string ihi, UserDetails user)
        {
            DoesPcehrExistResponse result = new DoesPcehrExistResponse();
            //bool validatePcehr = bool.Parse(ConfigurationManager.AppSettings["CheckDoesPcehrExist"].ToString());
            //if (!validatePcehr)
            //{

            //    return result;
            //}
            try
            {
                X509Certificate2 signingCert = Helpers.GetHpioCertificate();
                Uri url = Helpers.GetDoesPcehrUrl();
                result = Search(ihi, url, signingCert, user);
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog("Failed to validate that the PCEHR exists or not.", ex);
                throw new Exception("Failed to validate that the PCEHR exists or not.", ex);
            }
            return result;
        }

        /// <summary>
        /// Checks to see if the PCEHR exists for this patient, based on thier hospital record.
        /// </summary>
        /// <param name="mrn">The MRN.</param>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="dateOfBirth">The date of birth.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        public DoesPcehrExistResponse PcehrExists(string mrn, string hospitalCode, int namespaceId, DateTime dateOfBirth, UserDetails user)
        {
            DoesPcehrExistResponse result = new DoesPcehrExistResponse();
            PatientMasterDl dataAccess = new PatientMasterDl();
            PatientMaster patient = new PatientMaster();
            bool patientResult = dataAccess.Get(null, null, namespaceId, null, null, dateOfBirth, null, null, null, null, null, out patient);
            if (!patientResult)
            {
                result.Status = PcehrExistsReturnStatus.InvalidPatient;
                return result;
            }

            try
            {
                X509Certificate2 signingCert = Helpers.GetHpioCertificate();
                Uri url = Helpers.GetDoesPcehrUrl();
                result = Search(patient.Ihi, url, signingCert, user);
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog("Failed to validate that the PCEHR exists or not.", ex);
                result.Status = PcehrExistsReturnStatus.SystemError;
            }
            return result;
        }

        #endregion
    }
}
