﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HIPS.CommonSchemas
{


    public class UserDetails
    {
        /// <summary>
        /// Gets or sets the authorisation role for the B2B web service invocation.
        /// </summary>
        /// <value>
        /// The role.
        /// </value>
        public UserRole Role { get; set; }

        /// <summary>
        /// Gets or sets the HPI-I of the person logged in. This is the primary identifier for the Provider Individual role.
        /// </summary>
        /// <value>
        /// The HPI-I.
        /// </value>
        public string HpiI { get; set; }

        /// <summary>
        /// Gets or sets the locally-issued user ID, such as the Active Directory account.
        /// This is the primary identifier for the HI User role.
        /// </summary>
        /// <value>
        /// The login.
        /// </value>
        public string Login { get; set; }

        /// <summary>
        /// Gets or sets the type of the locally-issued user ID, such as the Active Directory domain.
        /// This is part of the qualified for the HI User role.
        /// </summary>
        /// <value>
        /// The domain.
        /// </value>
        public string Domain { get; set; }

        /// <summary>
        /// Gets or sets the name of the person logged in, or the name of the Responsible Officer. This is not sent to Medicare but will be audited.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the Authorised Employee user ID.
        /// This is used for B2B requests authorised in name of the Authorised Employee for the hospital.
        /// </summary>
        /// <value>
        /// The authorised employee.
        /// </value>
        public string AuthorisedEmployeeUserId { get; set; }
        
        /// <summary>
        /// Gets or sets the HPI-O of the healthcare provider organisation.
        /// </summary>
        /// <value>
        /// The HPI-O.
        /// </value>
        public string HpiO { get; set; }

        /// <summary>
        /// Gets or sets a flag indicating whether the caller is a contracted service provider.
        /// </summary>
        /// <value>
        /// Whether the caller is a contracted service provider.
        /// </value>
        public bool IsContractedServiceProvider { get; set; }
    }
}

