﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.PCEHR;

namespace HIPS.PcehrSchemas
{
    [KnownType(typeof(DocumentQuery))]
    [Serializable]
    [DataContract]
    public class DocumentQuery
    {
        #region Private Members

        private IList<DocumentStatus> documentStatus = null;
        private String documentUniqueId = null;
        private IList<ClassCodes> documentClassCode = null;
        private IList<PracticeSettingTypes> practiceSettingTypes = null;
        private IList<HealthcareFacilityTypeCodes> healthCareFacilityType = null;
        private DateTime? creationTimeFrom = null;
        private DateTime? creationTimeTo = null;
        private DateTime? serviceStartTimeFrom = null;
        private DateTime? serviceStartTimeTo = null;
        private DateTime? serviceStopTimeFrom = null;
        private DateTime? serviceStopTimeTo = null;
        private IList<string> formatCodes = null;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or Sets the DocumentStatus.
        /// NEHTA Document Status Types
        /// </summary>
        /// <value>
        /// The documentStatus
        /// </value>
        [DataMember]
        public IList<DocumentStatus> DocumentStatus
        {
            get { return documentStatus; }
            set { documentStatus = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentUniqueId.
        /// Unique ID for searching a single document.
        /// </summary>
        /// <value>
        /// The documentUniqueId
        /// </value>
        [DataMember]
        public String DocumentUniqueId
        {
            get { return documentUniqueId; }
            set { documentUniqueId = value; }
        }

        /// <summary>
        /// Gets or Sets the DocumentClassCode.
        /// Class codes (also called Document Type Codes) for the type of document.  Extended from the NEHTA APIs.
        /// </summary>
        /// <value>
        /// The documentClassCode
        /// </value>
        [DataMember]
        public IList<ClassCodes> DocumentClassCode
        {
            get { return documentClassCode; }
            set { documentClassCode = value; }
        }

        /// <summary>
        /// Gets or Sets the PracticeSettingTypes.
        /// Practice Settings (also called Clinical Speciality Codes) of the document.  Extended from the NEHTA APIs.
        /// </summary>
        /// <value>
        /// The practiceSettingTypes
        /// </value>
        [DataMember]
        public IList<PracticeSettingTypes> PracticeSettingTypes
        {
            get { return practiceSettingTypes; }
            set { practiceSettingTypes = value; }
        }

        /// <summary>
        /// Gets or Sets the HealthCareFacilityType.
        /// Health Care Facility Type for the document.  Extended from the NEHTA APIs.
        /// </summary>
        /// <value>
        /// The healthCareFacilityType
        /// </value>
        [DataMember]
        public IList<HealthcareFacilityTypeCodes> HealthCareFacilityType
        {
            get { return healthCareFacilityType; }
            set { healthCareFacilityType = value; }
        }

        /// <summary>
        /// Gets or Sets the CreationTimeFrom.
        /// Search from for the “Document Creation Time”
        /// </summary>
        /// <value>
        /// The creationTimeFrom
        /// </value>
        [DataMember]
        public DateTime? CreationTimeFrom
        {
            get { return creationTimeFrom; }
            set { creationTimeFrom = value; }
        }

        /// <summary>
        /// Gets or Sets the CreationTimeTo.
        /// Search To for the “Document Creation Time”
        /// </summary>
        /// <value>
        /// The creationTimeTo
        /// </value>
        [DataMember]
        public DateTime? CreationTimeTo
        {
            get { return creationTimeTo; }
            set { creationTimeTo = value; }
        }

        /// <summary>
        /// Gets or Sets the ServiceStartTimeFrom.
        /// Search From for the “The datetime the service being performed which caused the document to be started.”
        /// </summary>
        /// <value>
        /// The serviceStartTimeFrom
        /// </value>
        [DataMember]
        public DateTime? ServiceStartTimeFrom
        {
            get { return serviceStartTimeFrom; }
            set { serviceStartTimeFrom = value; }
        }

        /// <summary>
        /// Gets or Sets the ServiceStartTimeTo.
        /// Search To for the “The datetime the service being performed which caused the document to be started.”
        /// </summary>
        /// <value>
        /// The serviceStartTimeTo
        /// </value>
        [DataMember]
        public DateTime? ServiceStartTimeTo
        {
            get { return serviceStartTimeTo; }
            set { serviceStartTimeTo = value; }
        }

        /// <summary>
        /// Gets or Sets the ServiceStopTimeFrom.
        /// Search From for the “The datetime the service being performed which caused the document to be stopped.”
        /// </summary>
        /// <value>
        /// The serviceStopTimeFrom
        /// </value>
        [DataMember]
        public DateTime? ServiceStopTimeFrom
        {
            get { return serviceStopTimeFrom; }
            set { serviceStopTimeFrom = value; }
        }

        /// <summary>
        /// Gets or Sets the ServiceStopTimeTo.
        /// Search To for the “The datetime the service being performed which caused the document to be stopped.”
        /// </summary>
        /// <value>
        /// The serviceStopTimeTo
        /// </value>
        [DataMember]
        public DateTime? ServiceStopTimeTo
        {
            get { return serviceStopTimeTo; }
            set { serviceStopTimeTo = value; }
        }

        /// <summary>
        /// Gets or Sets the FormatCodes.
        /// Format codes for document conformance. Reference to the Code column in the DocumentFormat table.
        /// </summary>
        /// <value>
        /// The formatCodes
        /// </value>
        [DataMember]
        public IList<string> FormatCodes
        {
            get { return formatCodes; }
            set { formatCodes = value; }
        }

        #endregion Properties
    }
}