﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This class holds the returned response when a check to see if the patient has a PCEHR.
    /// </summary>
    [KnownType(typeof(DoesPcehrExistResponse))]
    [Serializable]
    [DataContract]
    public class DoesPcehrExistResponse
    {
        #region Private Members

        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError);
        private AccessCodeRequired accessCodeRequired = AccessCodeRequired.Unknown;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HIPS response, including indicator of success or failure and information about any failures.
        /// </summary>
        /// <value>
        /// The HIPS response.
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get
            {
                return hipsResponse;
            }
            set
            {
                hipsResponse = value;
            }
        }

        /// <summary>
        /// Gets or sets the does pcehr exists flag.
        /// </summary>
        /// <value>
        /// The pcehr exists.
        /// </value>

        [DataMember]
        public bool? PcehrExists { get; set; }

        /// <summary>
        /// Gets or sets the access code required indicator.
        /// </summary>
        /// <value>
        /// The access code required.
        /// </value>
        [DataMember]
        public AccessCodeRequired AccessCodeRequired
        {
            get
            {
                return accessCodeRequired;
            }
            set
            {
                accessCodeRequired = value;
            }
        }

        #endregion Properties
    }
}